/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import me.desht.pneumaticcraft.common.block.AbstractPneumaticCraftBlock;
import me.desht.pneumaticcraft.common.block.entity.CamouflageableBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.model.data.ModelProperty;

public abstract class AbstractCamouflageBlock
extends AbstractPneumaticCraftBlock {
    public static final ModelProperty<BlockState> CAMO_STATE = new ModelProperty();
    public static final ModelProperty<BlockGetter> BLOCK_ACCESS = new ModelProperty();
    public static final ModelProperty<BlockPos> BLOCK_POS = new ModelProperty();

    protected AbstractCamouflageBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof CamouflageableBlockEntity) {
            BlockState camoState;
            CamouflageableBlockEntity camo = (CamouflageableBlockEntity)te;
            if (!player.m_7500_() && (camoState = camo.getCamouflage()) != null) {
                ItemStack camoStack = CamouflageableBlockEntity.getStackForState(camoState);
                camo.setCamouflage(null);
                world.m_5898_(player, 2001, pos, AbstractCamouflageBlock.m_49956_((BlockState)camoState));
                ItemEntity entity = new ItemEntity(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, camoStack);
                world.m_7967_((Entity)entity);
                return false;
            }
        }
        return super.onDestroyedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext ctx) {
        CamouflageableBlockEntity camo = this.getCamoState(reader, pos);
        return camo == null ? this.getUncamouflagedShape(state, reader, pos, ctx) : camo.getCamouflage().m_60651_(reader, pos, ctx);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext ctx) {
        CamouflageableBlockEntity camo = this.getCamoState(reader, pos);
        return camo == null ? this.getUncamouflagedCollisionShape(state, reader, pos, ctx) : camo.getCamouflage().m_60742_(reader, pos, ctx);
    }

    public VoxelShape m_6079_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        CamouflageableBlockEntity camo = this.getCamoState(worldIn, pos);
        return camo == null ? this.getUncamouflagedRaytraceShape(state, worldIn, pos) : camo.getCamouflage().m_60771_(worldIn, pos, CollisionContext.m_82749_());
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        CamouflageableBlockEntity camo = this.getCamoState(worldIn, pos);
        return camo == null ? this.getUncamouflagedRenderShape(state, worldIn, pos) : camo.getCamouflage().m_60816_(worldIn, pos);
    }

    public int m_7753_(BlockState state, BlockGetter world, BlockPos pos) {
        CamouflageableBlockEntity camo = this.getCamoState(world, pos);
        return camo == null ? super.m_7753_(state, world, pos) : camo.getCamouflage().m_60739_(world, pos);
    }

    public boolean m_49967_() {
        return true;
    }

    private CamouflageableBlockEntity getCamoState(BlockGetter blockAccess, BlockPos pos) {
        CamouflageableBlockEntity camo;
        if (blockAccess == null || pos == null) {
            return null;
        }
        BlockEntity be = blockAccess.m_7702_(pos);
        return be instanceof CamouflageableBlockEntity && (camo = (CamouflageableBlockEntity)be).getCamouflage() != null ? (CamouflageableBlockEntity)be : null;
    }

    public abstract VoxelShape getUncamouflagedShape(BlockState var1, BlockGetter var2, BlockPos var3, CollisionContext var4);

    protected VoxelShape getUncamouflagedCollisionShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext ctx) {
        return this.getUncamouflagedShape(state, reader, pos, ctx);
    }

    protected VoxelShape getUncamouflagedRenderShape(BlockState state, BlockGetter reader, BlockPos pos) {
        return this.getUncamouflagedShape(state, reader, pos, CollisionContext.m_82749_());
    }

    protected VoxelShape getUncamouflagedRaytraceShape(BlockState state, BlockGetter reader, BlockPos pos) {
        return Shapes.m_83040_();
    }
}

