/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.fluid;

import java.util.BitSet;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class TankRenderInfo {
    private final IFluidTank tank;
    private final AABB bounds;
    private final BitSet faces = new BitSet(6);

    public TankRenderInfo(FluidStack stack, int capacity, AABB bounds, Direction ... renderFaces) {
        FluidTank tank = new FluidTank(capacity);
        tank.setFluid(stack);
        this.tank = tank;
        this.bounds = bounds;
        if (renderFaces.length == 0) {
            this.faces.set(0, 6, true);
        } else {
            for (Direction face : renderFaces) {
                this.faces.set(face.m_122411_(), true);
            }
        }
    }

    public TankRenderInfo(IFluidTank tank, AABB bounds, Direction ... renderFaces) {
        this(tank.getFluid(), tank.getCapacity(), bounds, renderFaces);
    }

    public TankRenderInfo without(Direction face) {
        this.faces.clear(face.m_122411_());
        return this;
    }

    public boolean shouldRender(Direction face) {
        return this.faces.get(face.m_122411_());
    }

    public IFluidTank getTank() {
        return this.tank;
    }

    public AABB getBounds() {
        return this.bounds;
    }

    public BitSet getFaces() {
        return this.faces;
    }
}

