/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import me.desht.pneumaticcraft.client.model.PNCModelLayers;
import me.desht.pneumaticcraft.client.render.blockentity.AbstractBlockEntityModelRenderer;
import me.desht.pneumaticcraft.client.render.fluid.AbstractFluidTER;
import me.desht.pneumaticcraft.client.render.fluid.TankRenderInfo;
import me.desht.pneumaticcraft.common.block.entity.SpawnerExtractorBlockEntity;
import me.desht.pneumaticcraft.common.core.ModFluids;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.fluids.FluidStack;

public class SpawnerExtractorRenderer
extends AbstractBlockEntityModelRenderer<SpawnerExtractorBlockEntity> {
    private static final AABB FLUID_BB = new AABB(0.375, 0.0, 0.375, 0.625, 1.0, 0.625);
    private static final String MODEL = "model";
    private final ModelPart model;

    public SpawnerExtractorRenderer(BlockEntityRendererProvider.Context ctx) {
        super(ctx);
        ModelPart root = ctx.m_173582_(PNCModelLayers.SPAWNER_EXTRACTOR);
        this.model = root.m_171324_(MODEL);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_(MODEL, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171544_("model_0", -3.0f, -16.25f, -3.0f, 6, 1, 6, new CubeDeformation(-0.01f), 23, 57).m_171544_("model_1", -3.0f, -14.75f, -3.0f, 6, 1, 6, new CubeDeformation(-0.01f), 23, 57).m_171544_("model_2", -2.5f, -15.5f, -2.5f, 5, 1, 5, new CubeDeformation(-0.01f), 44, 57).m_171534_("model_3", -1.0f, -16.0f, -1.0f, 2, 16, 2, 15, 46).m_171480_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    @Override
    void renderModel(SpawnerExtractorBlockEntity te, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        VertexConsumer builder = bufferIn.m_6299_(RenderType.m_110452_((ResourceLocation)Textures.MODEL_SPAWNER_EXTRACTOR));
        float extension = te.getProgress() * -0.75f;
        matrixStackIn.m_252880_(0.0f, extension, 0.0f);
        this.model.m_104301_(matrixStackIn, builder, combinedLightIn, combinedOverlayIn);
    }

    @Override
    protected void renderExtras(SpawnerExtractorBlockEntity te, float partialTicks, PoseStack matrixStack, MultiBufferSource iRenderTypeBuffer, int combinedLightIn, int combinedOverlayIn) {
        if (te.getProgress() > 0.0f && te.getProgress() < 1.0f) {
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.0, 0.8125, 0.0);
            VertexConsumer builder = iRenderTypeBuffer.m_6299_(RenderType.m_110470_((ResourceLocation)TextureAtlas.f_118259_));
            TankRenderInfo info = new TankRenderInfo(new FluidStack((Fluid)ModFluids.MEMORY_ESSENCE.get(), (int)(1000.0f * te.getProgress())), 1000, FLUID_BB, new Direction[0]);
            AbstractFluidTER.renderFluid(builder, info, matrixStack.m_85850_().m_252922_(), combinedLightIn, combinedOverlayIn);
            matrixStack.m_85849_();
        }
    }
}

