/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.tubemodule;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import me.desht.pneumaticcraft.client.gui.tubemodule.AbstractTubeModuleScreen;
import me.desht.pneumaticcraft.client.gui.tubemodule.SimplePressureGaugeModuleScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetCheckBox;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTooltipArea;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketUpdatePressureModule;
import me.desht.pneumaticcraft.common.tubemodules.AbstractRedstoneReceivingModule;
import me.desht.pneumaticcraft.common.tubemodules.AbstractTubeModule;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;

public class PressureGaugeModuleScreen
extends AbstractTubeModuleScreen<AbstractTubeModule> {
    private EditBox lowerBoundField;
    private EditBox higherBoundField;
    private int graphLowY;
    private int graphHighY;
    private int graphLeft;
    private int graphRight;
    private Rect2i lowerBoundArea;
    private Rect2i higherBoundArea;
    private boolean grabLower;
    private boolean grabHigher;

    public static AbstractTubeModuleScreen<?> createGUI(AbstractTubeModule module) {
        return module.advancedConfig ? new PressureGaugeModuleScreen(module) : new SimplePressureGaugeModuleScreen(module);
    }

    public PressureGaugeModuleScreen(AbstractTubeModule module) {
        super(module);
        this.ySize = 191;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        int xStart = (this.f_96543_ - this.xSize) / 2;
        int yStart = (this.f_96544_ - this.ySize) / 2;
        this.addLabel((Component)Component.m_237113_((String)"lower"), this.guiLeft + 15, this.guiTop + 33);
        this.addLabel((Component)Component.m_237113_((String)"bar"), this.guiLeft + 50, this.guiTop + 44);
        this.addLabel((Component)Component.m_237113_((String)"higher"), this.guiLeft + 140, this.guiTop + 33);
        this.addLabel(this.f_96539_, this.f_96543_ / 2 - this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2, this.guiTop + 5);
        this.lowerBoundField = new EditBox(this.f_96547_, xStart + 15, yStart + 43, 30, 10, (Component)Component.m_237113_((String)PneumaticCraftUtils.roundNumberTo(this.module.lowerBound, 1)));
        this.lowerBoundField.m_94151_(s -> this.updateBoundFromTextfield(0));
        this.m_142416_((GuiEventListener)this.lowerBoundField);
        this.higherBoundField = new EditBox(this.f_96547_, xStart + 140, yStart + 43, 30, 10, (Component)Component.m_237113_((String)PneumaticCraftUtils.roundNumberTo(this.module.higherBound, 1)));
        this.higherBoundField.m_94151_(s -> this.updateBoundFromTextfield(1));
        this.m_142416_((GuiEventListener)this.higherBoundField);
        this.graphLowY = this.guiTop + 158;
        this.graphHighY = this.guiTop + 98;
        this.graphLeft = this.guiLeft + 22;
        this.graphRight = this.guiLeft + 172;
        this.m_142416_((GuiEventListener)new WidgetTooltipArea(this.graphLeft - 20, this.graphHighY, 25, this.graphLowY - this.graphHighY, new Component[]{PneumaticCraftUtils.xlate("pneumaticcraft.gui.redstone", new Object[0])}));
        this.m_142416_((GuiEventListener)new WidgetTooltipArea(this.graphLeft, this.graphLowY - 5, this.graphRight - this.graphLeft, 25, new Component[]{PneumaticCraftUtils.xlate("pneumaticcraft.gui.threshold", new Object[0])}));
        WidgetAnimatedStat stat = new WidgetAnimatedStat(this, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info", new Object[0]), WidgetAnimatedStat.StatIcon.of(Textures.GUI_INFO_LOCATION), xStart, yStart + 5, -7829249, null, true);
        stat.setText((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tab.info.tubeModule", new Object[0]));
        stat.setBeveled(true);
        this.m_142416_(stat);
        WidgetCheckBox advancedMode = new WidgetCheckBox(this.guiLeft + 6, this.guiTop + 20, -12566464, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tubeModule.advancedConfig", new Object[0]), b -> {
            this.module.advancedConfig = b.checked;
            NetworkHandler.sendToServer(new PacketUpdatePressureModule(this.module));
        }).setChecked(true);
        advancedMode.m_257544_(Tooltip.m_257550_((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tubeModule.advancedConfig.tooltip", new Object[0])));
        this.m_142416_((GuiEventListener)advancedMode);
        this.higherBoundArea = new Rect2i(this.guiLeft + 11, this.guiTop + 59, 158, 15);
        this.lowerBoundArea = new Rect2i(this.guiLeft + 11, this.guiTop + 73, 158, 15);
    }

    @Override
    protected ResourceLocation getTexture() {
        return Textures.GUI_TUBE_MODULE;
    }

    @Override
    public void drawForeground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int scrollbarLowerBoundX = (int)((float)(this.guiLeft + 16) + 146.0f * (this.module.lowerBound / 31.0f));
        int scrollbarHigherBoundX = (int)((float)(this.guiLeft + 16) + 146.0f * (this.module.higherBound / 31.0f));
        graphics.m_280218_(this.getTexture(), scrollbarLowerBoundX, this.guiTop + 73, 183, 0, 15, 12);
        graphics.m_280218_(this.getTexture(), scrollbarHigherBoundX, this.guiTop + 59, 183, 0, 15, 12);
        this.renderGraph(graphics);
        if (this.module instanceof AbstractRedstoneReceivingModule) {
            this.module.onNeighborBlockUpdate();
            graphics.m_280656_(this.graphLeft + 4, this.graphRight, this.graphHighY + (this.graphLowY - this.graphHighY) * (15 - ((AbstractRedstoneReceivingModule)this.module).getReceivingRedstoneLevel()) / 15, -65536);
            String status = I18n.m_118938_((String)"pneumaticcraft.gui.tubeModule.simpleConfig.threshold", (Object[])new Object[0]) + " " + PneumaticCraftUtils.roundNumberTo(((AbstractRedstoneReceivingModule)this.module).getThreshold(), 1) + " bar";
            graphics.drawString(this.f_96547_, status, (float)this.guiLeft + (float)this.xSize / 2.0f - (float)this.f_96547_.m_92895_(status) / 2.0f, (float)(this.guiTop + 175), -12566464, false);
        }
        RenderSystem.setShader(GameRenderer::m_172811_);
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        Matrix4f posMat = graphics.m_280168_().m_85850_().m_252922_();
        for (int i = 0; i < 16; ++i) {
            float y = (float)this.graphHighY + (float)((this.graphLowY - this.graphHighY) * (15 - i)) / 15.0f;
            float x = (float)this.graphLeft + (float)(this.graphRight - this.graphLeft) * this.module.getThreshold(i) / 30.0f;
            bufferBuilder.m_252986_(posMat, x, y, 90.0f).m_85950_(0.25f + (float)i * 0.05f, 0.0f, 0.0f, 1.0f).m_5752_();
        }
        Tesselator.m_85913_().m_85914_();
        RenderSystem.disableBlend();
    }

    private void renderGraph(GuiGraphics graphics) {
        String txt;
        boolean longer;
        int i;
        graphics.m_280315_(this.graphLeft, this.graphHighY, this.graphLowY, -13619152);
        for (i = 0; i < 16; ++i) {
            boolean bl = longer = i % 5 == 0;
            if (longer) {
                txt = String.valueOf(i);
                graphics.drawString(this.f_96547_, txt, (float)(this.graphLeft - 5 - this.f_96547_.m_92895_(txt)), (float)this.graphHighY + (float)((this.graphLowY - this.graphHighY) * (15 - i)) / 15.0f - 3.0f, -13619152, false);
                graphics.m_280656_(this.graphLeft + 4, this.graphRight, this.graphHighY + (this.graphLowY - this.graphHighY) * (15 - i) / 15, i == 0 ? -13619152 : 0x33000000);
            }
            graphics.m_280656_(this.graphLeft - (longer ? 5 : 3), this.graphLeft + 3, this.graphHighY + (this.graphLowY - this.graphHighY) * (15 - i) / 15, -13619152);
        }
        for (i = 0; i < 31; ++i) {
            boolean bl = longer = i % 5 == 0;
            if (longer) {
                txt = String.valueOf(i);
                graphics.drawString(this.f_96547_, txt, (float)this.graphLeft + (float)((this.graphRight - this.graphLeft) * i) / 30.0f - (float)this.f_96547_.m_92895_(txt) / 2.0f + 1.0f, (float)(this.graphLowY + 6), -13619152, false);
                graphics.m_280315_(this.graphLeft + (this.graphRight - this.graphLeft) * i / 30, this.graphHighY, this.graphLowY - 2, 0x33000000);
            }
            graphics.m_280315_(this.graphLeft + (this.graphRight - this.graphLeft) * i / 30, this.graphLowY - 3, this.graphLowY + (longer ? 5 : 3), -13619152);
        }
    }

    private void updateBoundFromTextfield(int fieldId) {
        try {
            switch (fieldId) {
                case 0: {
                    float prev = this.module.lowerBound;
                    this.module.lowerBound = Mth.m_14036_((float)Float.parseFloat(this.lowerBoundField.m_94155_()), (float)-1.0f, (float)30.0f);
                    if (!Mth.m_14033_((float)this.module.lowerBound, (float)prev)) {
                        NetworkHandler.sendToServer(new PacketUpdatePressureModule(this.module));
                    }
                    break;
                }
                case 1: {
                    float prev = this.module.higherBound;
                    this.module.higherBound = Mth.m_14036_((float)Float.parseFloat(this.higherBoundField.m_94155_()), (float)-1.0f, (float)30.0f);
                    if (!Mth.m_14033_((float)this.module.higherBound, (float)prev)) {
                        NetworkHandler.sendToServer(new PacketUpdatePressureModule(this.module));
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown field id " + fieldId);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        if (this.lowerBoundArea.m_110087_((int)mouseX, (int)mouseY)) {
            this.module.lowerBound = (float)(mouseX - 6.0 - (double)(this.guiLeft + 11)) / 147.0f * 30.0f;
            this.module.lowerBound = Math.min(Math.max(-1.0f, this.module.lowerBound), 30.0f);
            this.grabLower = true;
            return true;
        }
        if (this.higherBoundArea.m_110087_((int)mouseX, (int)mouseY)) {
            this.module.higherBound = (float)(mouseX - 6.0 - (double)(this.guiLeft + 11)) / 147.0f * 30.0f;
            this.module.higherBound = Math.min(Math.max(-1.0f, this.module.higherBound), 30.0f);
            this.grabHigher = true;
            return true;
        }
        return super.m_6375_(mouseX, mouseY, mouseButton);
    }

    public boolean m_7979_(double mouseX, double mouseY, int clickedMouseButton, double dx, double dy) {
        if (this.grabLower) {
            this.module.lowerBound = (float)(mouseX - 6.0 - (double)(this.guiLeft + 11)) / 147.0f * 30.0f;
            this.module.lowerBound = Math.min(Math.max(-1.0f, this.module.lowerBound), 30.0f);
            return true;
        }
        if (this.grabHigher) {
            this.module.higherBound = (float)(mouseX - 6.0 - (double)(this.guiLeft + 11)) / 147.0f * 30.0f;
            this.module.higherBound = Math.min(Math.max(-1.0f, this.module.higherBound), 30.0f);
            return true;
        }
        return super.m_7979_(mouseX, mouseY, clickedMouseButton, dx, dy);
    }

    public boolean m_6348_(double mouseX, double mouseY, int state) {
        if (this.grabLower) {
            NetworkHandler.sendToServer(new PacketUpdatePressureModule(this.module));
            this.grabLower = false;
            return true;
        }
        if (this.grabHigher) {
            NetworkHandler.sendToServer(new PacketUpdatePressureModule(this.module));
            this.grabHigher = false;
            return true;
        }
        return super.m_6348_(mouseX, mouseY, state);
    }

    @Override
    public void m_86600_() {
        super.m_86600_();
        if (!this.module.advancedConfig) {
            this.f_96541_.m_91152_((Screen)new SimplePressureGaugeModuleScreen(this.module));
        }
        if (!this.lowerBoundField.m_93696_()) {
            this.lowerBoundField.m_94144_(PneumaticCraftUtils.roundNumberTo(this.module.lowerBound, 1));
        }
        if (!this.higherBoundField.m_93696_()) {
            this.higherBoundField.m_94144_(PneumaticCraftUtils.roundNumberTo(this.module.higherBound, 1));
        }
    }
}

