/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia.codec;

import com.mojang.datafixers.util.Either;
import io.netty.handler.codec.EncoderException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.IntFunction;
import mcjty.lib.varia.codec.StreamCodec;
import net.minecraft.network.FriendlyByteBuf;
import org.joml.Vector3f;

public interface StandardCodecs {
    public static final StreamCodec<FriendlyByteBuf, Boolean> BOOL = new StreamCodec<FriendlyByteBuf, Boolean>(){

        @Override
        public Boolean decode(FriendlyByteBuf buf) {
            return buf.readBoolean();
        }

        @Override
        public void encode(FriendlyByteBuf buf, Boolean val) {
            buf.writeBoolean(val.booleanValue());
        }
    };
    public static final StreamCodec<FriendlyByteBuf, Byte> BYTE = new StreamCodec<FriendlyByteBuf, Byte>(){

        @Override
        public Byte decode(FriendlyByteBuf buf) {
            return buf.readByte();
        }

        @Override
        public void encode(FriendlyByteBuf buf, Byte val) {
            buf.writeByte((int)val.byteValue());
        }
    };
    public static final StreamCodec<FriendlyByteBuf, Short> SHORT = new StreamCodec<FriendlyByteBuf, Short>(){

        @Override
        public Short decode(FriendlyByteBuf buf) {
            return buf.readShort();
        }

        @Override
        public void encode(FriendlyByteBuf buf, Short val) {
            buf.writeShort((int)val.shortValue());
        }
    };
    public static final StreamCodec<FriendlyByteBuf, Integer> UNSIGNED_SHORT = new StreamCodec<FriendlyByteBuf, Integer>(){

        @Override
        public Integer decode(FriendlyByteBuf buf) {
            return buf.readUnsignedShort();
        }

        @Override
        public void encode(FriendlyByteBuf buf, Integer val) {
            buf.writeShort(val.intValue());
        }
    };
    public static final StreamCodec<FriendlyByteBuf, Integer> INT = new StreamCodec<FriendlyByteBuf, Integer>(){

        @Override
        public Integer decode(FriendlyByteBuf buf) {
            return buf.readInt();
        }

        @Override
        public void encode(FriendlyByteBuf buf, Integer val) {
            buf.writeInt(val.intValue());
        }
    };
    public static final StreamCodec<FriendlyByteBuf, Float> FLOAT = new StreamCodec<FriendlyByteBuf, Float>(){

        @Override
        public Float decode(FriendlyByteBuf buf) {
            return Float.valueOf(buf.readFloat());
        }

        @Override
        public void encode(FriendlyByteBuf buf, Float val) {
            buf.writeFloat(val.floatValue());
        }
    };
    public static final StreamCodec<FriendlyByteBuf, Double> DOUBLE = new StreamCodec<FriendlyByteBuf, Double>(){

        @Override
        public Double decode(FriendlyByteBuf buf) {
            return buf.readDouble();
        }

        @Override
        public void encode(FriendlyByteBuf buf, Double val) {
            buf.writeDouble(val.doubleValue());
        }
    };
    public static final StreamCodec<FriendlyByteBuf, byte[]> BYTE_ARRAY = new StreamCodec<FriendlyByteBuf, byte[]>(){

        @Override
        public byte[] decode(FriendlyByteBuf buffer) {
            return buffer.m_130052_();
        }

        @Override
        public void encode(FriendlyByteBuf buffer, byte[] value) {
            buffer.m_130087_(value);
        }
    };
    public static final StreamCodec<FriendlyByteBuf, short[]> SHORT_ARRAY = new StreamCodec<FriendlyByteBuf, short[]>(){

        @Override
        public short[] decode(FriendlyByteBuf buffer) {
            int cnt = buffer.m_130242_();
            if (cnt <= 0) {
                return new short[0];
            }
            short[] value = new short[cnt];
            for (int i = 0; i < cnt; ++i) {
                value[i] = buffer.readShort();
            }
            return value;
        }

        @Override
        public void encode(FriendlyByteBuf buffer, short[] value) {
            buffer.m_130130_(value.length);
            for (short v : value) {
                buffer.writeShort((int)v);
            }
        }
    };
    public static final StreamCodec<FriendlyByteBuf, int[]> INT_ARRAY = new StreamCodec<FriendlyByteBuf, int[]>(){

        @Override
        public int[] decode(FriendlyByteBuf buffer) {
            int cnt = buffer.m_130242_();
            if (cnt <= 0) {
                return new int[0];
            }
            int[] value = new int[cnt];
            for (int i = 0; i < cnt; ++i) {
                value[i] = buffer.readInt();
            }
            return value;
        }

        @Override
        public void encode(FriendlyByteBuf buffer, int[] value) {
            buffer.m_130130_(value.length);
            for (int v : value) {
                buffer.writeInt(v);
            }
        }
    };
    public static final StreamCodec<FriendlyByteBuf, Vector3f> VECTOR3F = new StreamCodec<FriendlyByteBuf, Vector3f>(){

        @Override
        public Vector3f decode(FriendlyByteBuf buf) {
            return buf.m_269394_();
        }

        @Override
        public void encode(FriendlyByteBuf buf, Vector3f value) {
            buf.m_269582_(value);
        }
    };
    public static final StreamCodec<FriendlyByteBuf, String> STRING_UTF8 = StandardCodecs.stringUtf8(Short.MAX_VALUE);

    public static StreamCodec<FriendlyByteBuf, byte[]> byteArray(final int maxSize) {
        return new StreamCodec<FriendlyByteBuf, byte[]>(){

            @Override
            public byte[] decode(FriendlyByteBuf buf) {
                return buf.m_130101_(maxSize);
            }

            @Override
            public void encode(FriendlyByteBuf buf, byte[] array) {
                if (array.length > maxSize) {
                    throw new EncoderException("ByteArray with size " + array.length + " is bigger than allowed " + maxSize);
                }
                buf.m_130087_(array);
            }
        };
    }

    public static StreamCodec<FriendlyByteBuf, String> stringUtf8(final int maxLength) {
        return new StreamCodec<FriendlyByteBuf, String>(){

            @Override
            public String decode(FriendlyByteBuf buf) {
                return buf.m_130136_(maxLength);
            }

            @Override
            public void encode(FriendlyByteBuf buf, String str) {
                buf.m_130072_(str, maxLength);
            }
        };
    }

    public static <B extends FriendlyByteBuf, V> StreamCodec<B, Optional<V>> optional(final StreamCodec<B, V> codec) {
        return new StreamCodec<B, Optional<V>>(){

            @Override
            public Optional<V> decode(B buf) {
                return buf.readBoolean() ? Optional.of(codec.decode(buf)) : Optional.empty();
            }

            @Override
            public void encode(B buf, Optional<V> val) {
                if (val.isPresent()) {
                    buf.writeBoolean(true);
                    codec.encode(buf, val.get());
                } else {
                    buf.writeBoolean(false);
                }
            }
        };
    }

    public static <B extends FriendlyByteBuf, V, C extends Collection<V>> StreamCodec<B, C> collection(IntFunction<C> factory, StreamCodec<? super B, V> codec) {
        return StandardCodecs.collection(factory, codec, Integer.MAX_VALUE);
    }

    public static <B extends FriendlyByteBuf, V, C extends Collection<V>> StreamCodec<B, C> collection(final IntFunction<C> factory, final StreamCodec<? super B, V> codec, int maxSize) {
        return new StreamCodec<B, C>(){

            @Override
            public C decode(B buf) {
                int size = buf.readInt();
                Collection c = (Collection)factory.apply(Math.min(size, 65536));
                for (int i = 0; i < size; ++i) {
                    c.add(codec.decode(buf));
                }
                return c;
            }

            @Override
            public void encode(B buf, C collection) {
                buf.writeInt(collection.size());
                for (Object v : collection) {
                    codec.encode(buf, v);
                }
            }
        };
    }

    public static <B extends FriendlyByteBuf, V, C extends Collection<V>> StreamCodec.CodecOperation<B, V, C> collection(IntFunction<C> factory) {
        return buf -> StandardCodecs.collection(factory, buf);
    }

    public static <B extends FriendlyByteBuf, V> StreamCodec.CodecOperation<B, V, List<V>> list() {
        return buf -> StandardCodecs.collection(ArrayList::new, buf);
    }

    public static <B extends FriendlyByteBuf, V> StreamCodec.CodecOperation<B, V, List<V>> list(int maxSize) {
        return buf -> StandardCodecs.collection(ArrayList::new, buf, maxSize);
    }

    public static <B extends FriendlyByteBuf, L, R> StreamCodec<B, Either<L, R>> either(final StreamCodec<? super B, L> leftCodec, final StreamCodec<? super B, R> rightCodec) {
        return new StreamCodec<B, Either<L, R>>(){

            @Override
            public Either<L, R> decode(B buf) {
                return buf.readBoolean() ? Either.left(leftCodec.decode(buf)) : Either.right(rightCodec.decode(buf));
            }

            @Override
            public void encode(B buf, Either<L, R> val) {
                val.ifLeft(left -> {
                    buf.writeBoolean(true);
                    leftCodec.encode(buf, left);
                }).ifRight(right -> {
                    buf.writeBoolean(false);
                    rightCodec.encode(buf, right);
                });
            }
        };
    }
}

