/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import mcjty.lib.network.CustomPacketPayload;
import mcjty.lib.varia.SafeClientTools;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class PlayPayloadContext {
    private final Supplier<NetworkEvent.Context> supplier;

    public PlayPayloadContext(Supplier<NetworkEvent.Context> supplier) {
        this.supplier = supplier;
    }

    public WorkHandler workHandler() {
        return new WorkHandler(this.supplier.get());
    }

    public Optional<Player> player() {
        ServerPlayer sender = this.supplier.get().getSender();
        if (sender == null) {
            sender = SafeClientTools.getClientPlayer();
        }
        return Optional.ofNullable(sender);
    }

    public static <T extends CustomPacketPayload> BiConsumer<T, Supplier<NetworkEvent.Context>> wrap(BiConsumer<T, PlayPayloadContext> handler) {
        return (packet, supplier) -> {
            NetworkEvent.Context context = (NetworkEvent.Context)supplier.get();
            handler.accept(packet, new PlayPayloadContext(() -> context));
            context.setPacketHandled(true);
        };
    }

    public static class WorkHandler {
        private final NetworkEvent.Context ctx;

        public WorkHandler(NetworkEvent.Context ctx) {
            this.ctx = ctx;
        }

        public void submitAsync(Runnable runnable) {
            this.ctx.enqueueWork(runnable);
        }
    }
}

