/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import mcjty.lib.api.container.IContainerDataListener;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.network.CustomPacketPayload;
import mcjty.lib.network.PlayPayloadContext;
import mcjty.lib.varia.SafeClientTools;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;

public record PacketContainerDataToClient(ResourceLocation containerId, FriendlyByteBuf buffer) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("mcjtylib", "containerdata");

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130085_(this.containerId);
        int l = this.buffer.array().length;
        buf.writeInt(l);
        buf.writeBytes(this.buffer.array());
    }

    @Override
    public ResourceLocation id() {
        return ID;
    }

    public static PacketContainerDataToClient create(ResourceLocation id, FriendlyByteBuf buffer) {
        return new PacketContainerDataToClient(id, buffer);
    }

    public static PacketContainerDataToClient create(FriendlyByteBuf buf) {
        ResourceLocation containerId = buf.m_130281_();
        int l = buf.readInt();
        ByteBuf newbuf = Unpooled.buffer((int)l);
        byte[] bytes = new byte[l];
        buf.readBytes(bytes);
        newbuf.writeBytes(bytes);
        FriendlyByteBuf buffer = new FriendlyByteBuf(newbuf);
        return new PacketContainerDataToClient(containerId, buffer);
    }

    public void handle(PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> {
            GenericContainer gc;
            IContainerDataListener listener;
            AbstractContainerMenu container = SafeClientTools.getClientPlayer().f_36096_;
            if (container instanceof GenericContainer && (listener = (gc = (GenericContainer)container).getListener(this.containerId)) != null) {
                listener.readBuf(this.buffer);
            }
        });
    }
}

