/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import mcjty.lib.base.GeneralConfig;
import mcjty.lib.blockcommands.CommandInfo;
import mcjty.lib.network.IServerCommand;
import mcjty.lib.preferences.PreferencesProperties;
import mcjty.lib.setup.ClientSetup;
import mcjty.lib.setup.ModSetup;
import mcjty.lib.setup.Registration;
import mcjty.lib.typed.TypedMap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.commons.lang3.tuple.Pair;

@Mod(value="mcjtylib")
public class McJtyLib {
    public static final String MODID = "mcjtylib";
    public static final ModSetup setup = new ModSetup();
    public static McJtyLib instance;
    private static final Map<Pair<String, String>, IServerCommand> serverCommands;
    private static final Map<Pair<String, String>, IServerCommand> clientCommands;
    private static final Map<String, CommandInfo> commandInfos;

    public McJtyLib() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        Dist dist = FMLEnvironment.dist;
        instance = this;
        Registration.init(bus);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(setup::init);
        if (dist.isClient()) {
            bus.addListener(ClientSetup::init);
            bus.addListener(ClientSetup::registerKeyBinds);
            bus.addListener(ClientSetup::registerClientComponentTooltips);
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)GeneralConfig.CLIENT_CONFIG);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)GeneralConfig.SERVER_CONFIG);
    }

    public static <T> void registerListCommandInfo(String command, Class<T> type, Function<FriendlyByteBuf, T> deserializer, BiConsumer<FriendlyByteBuf, T> serializer) {
        commandInfos.put(command, new CommandInfo<T>(type, deserializer, serializer));
    }

    public static CommandInfo getCommandInfo(String command) {
        return commandInfos.get(command);
    }

    public static void registerCommand(String modid, String id, IServerCommand command) {
        serverCommands.put((Pair<String, String>)Pair.of((Object)modid, (Object)id), command);
    }

    public static void registerClientCommand(String modid, String id, IServerCommand command) {
        clientCommands.put((Pair<String, String>)Pair.of((Object)modid, (Object)id), command);
    }

    public static boolean handleCommand(String modid, String id, Player player, TypedMap arguments) {
        IServerCommand command = serverCommands.get(Pair.of((Object)modid, (Object)id));
        if (command == null) {
            return false;
        }
        return command.execute(player, arguments);
    }

    public static boolean handleClientCommand(String modid, String id, Player player, TypedMap arguments) {
        IServerCommand command = clientCommands.get(Pair.of((Object)modid, (Object)id));
        if (command == null) {
            return false;
        }
        return command.execute(player, arguments);
    }

    public static LazyOptional<PreferencesProperties> getPreferencesProperties(Player player) {
        return player.getCapability(ModSetup.PREFERENCES_CAPABILITY);
    }

    static {
        serverCommands = new HashMap<Pair<String, String>, IServerCommand>();
        clientCommands = new HashMap<Pair<String, String>, IServerCommand>();
        commandInfos = new HashMap<String, CommandInfo>();
    }
}

