/*
 * Decompiled with CFR 0.152.
 */
package com.github.almostreliable.energymeter.network;

import com.github.almostreliable.energymeter.network.Packet;
import com.github.almostreliable.energymeter.network.packets.AccuracyUpdatePacket;
import com.github.almostreliable.energymeter.network.packets.ClientSyncPacket;
import com.github.almostreliable.energymeter.network.packets.IOUpdatePacket;
import com.github.almostreliable.energymeter.network.packets.SettingUpdatePacket;
import com.github.almostreliable.energymeter.util.TextUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public final class PacketHandler {
    private static final ResourceLocation ID = TextUtils.getRL("network");
    private static final String PROTOCOL = "1";
    public static final SimpleChannel CHANNEL = NetworkRegistry.ChannelBuilder.named((ResourceLocation)ID).networkProtocolVersion(() -> "1").clientAcceptedVersions("1"::equals).serverAcceptedVersions("1"::equals).simpleChannel();

    private PacketHandler() {
    }

    public static void init() {
        int id = -1;
        PacketHandler.register(++id, ClientSyncPacket.class, new ClientSyncPacket());
        PacketHandler.register(++id, AccuracyUpdatePacket.class, new AccuracyUpdatePacket());
        PacketHandler.register(++id, IOUpdatePacket.class, new IOUpdatePacket());
        PacketHandler.register(++id, SettingUpdatePacket.class, new SettingUpdatePacket());
    }

    private static <T> void register(int packetId, Class<T> clazz, Packet<T> packet) {
        CHANNEL.registerMessage(packetId, clazz, packet::encode, packet::decode, packet::handle);
    }
}

