/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.pylons.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.LogicalSide;
import net.permutated.pylons.util.TranslationKey;

public class PlayerFilterCard
extends Item {
    public PlayerFilterCard() {
        super(new Item.Properties().m_41487_(1).setNoRepair());
    }

    public static void onPlayerInteractEvent(PlayerInteractEvent.EntityInteract event) {
        ItemStack itemStack = event.getItemStack();
        if (itemStack.m_41720_() instanceof PlayerFilterCard && event.getTarget() instanceof Player) {
            if (event.getSide() == LogicalSide.SERVER) {
                CompoundTag tag = itemStack.m_41698_("pylons");
                tag.m_128362_("uuid", event.getTarget().m_20148_());
                tag.m_128359_("name", PlayerFilterCard.getProfileName(event.getTarget()));
                event.setCancellationResult(InteractionResult.SUCCESS);
            } else {
                event.setCancellationResult(InteractionResult.CONSUME);
            }
            event.setCanceled(true);
        }
    }

    protected static String getProfileName(Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return player.m_36316_().getName();
        }
        return "unknown";
    }

    public boolean m_5812_(ItemStack stack) {
        CompoundTag tag = stack.m_41737_("pylons");
        return tag != null && tag.m_128403_("uuid");
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        CompoundTag tag = stack.m_41737_("pylons");
        if (tag != null) {
            String username = tag.m_128461_("name");
            tooltip.add((Component)this.translate("player", username).m_130940_(ChatFormatting.BLUE));
            tooltip.add((Component)Component.m_237119_());
            tooltip.add((Component)this.translate("insert1"));
            tooltip.add((Component)this.translate("insert2"));
        } else {
            tooltip.add((Component)this.translate("no_player"));
        }
    }

    protected MutableComponent translate(String key) {
        return Component.m_237115_((String)TranslationKey.tooltip(key)).m_130940_(ChatFormatting.GRAY);
    }

    protected MutableComponent translate(String key, Object ... values) {
        return Component.m_237110_((String)TranslationKey.tooltip(key), (Object[])values);
    }
}

