/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.registries;

import elucent.eidolon.api.spells.Rune;
import elucent.eidolon.api.spells.SignSequence;
import elucent.eidolon.registries.Signs;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public class Runes {
    static final Map<ResourceLocation, Rune> runes = new HashMap<ResourceLocation, Rune>();

    public static void register(Rune rune) {
        runes.put(rune.getRegistryName(), rune);
    }

    public static Rune find(ResourceLocation rl) {
        return runes.getOrDefault(rl, null);
    }

    public static Collection<Rune> getRunes() {
        return runes.values();
    }

    public static void init() {
        Runes.register(new Rune(new ResourceLocation("eidolon", "sin")){

            @Override
            public Rune.RuneResult doEffect(SignSequence seq) {
                seq.addRight(Signs.WICKED_SIGN);
                return Rune.RuneResult.PASS;
            }
        });
        Runes.register(new Rune(new ResourceLocation("eidolon", "crimson_rose")){

            @Override
            public Rune.RuneResult doEffect(SignSequence seq) {
                if (seq.removeRightmostN(Signs.WICKED_SIGN, 2)) {
                    seq.addRight(Signs.BLOOD_SIGN);
                    return Rune.RuneResult.PASS;
                }
                return Rune.RuneResult.FAIL;
            }
        });
        Runes.register(new Rune(new ResourceLocation("eidolon", "wing")){

            @Override
            public Rune.RuneResult doEffect(SignSequence seq) {
                return Rune.RuneResult.PASS;
            }
        });
        Runes.register(new Rune(new ResourceLocation("eidolon", "purity")){

            @Override
            public Rune.RuneResult doEffect(SignSequence seq) {
                return Rune.RuneResult.PASS;
            }
        });
    }
}

