/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.network;

import elucent.eidolon.api.spells.Sign;
import elucent.eidolon.gui.ScriptoriumContainer;
import elucent.eidolon.registries.Signs;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class InscribePacket {
    final List<Sign> signs = new ArrayList<Sign>();
    final int id;

    public InscribePacket(int uuid, List<Sign> runes) {
        this.signs.addAll(runes);
        this.id = uuid;
    }

    public static void encode(InscribePacket object, FriendlyByteBuf buffer) {
        buffer.writeInt(object.signs.size());
        for (int i = 0; i < object.signs.size(); ++i) {
            buffer.m_130072_(object.signs.get(i).getRegistryName().toString(), 255);
        }
        buffer.writeInt(object.id);
    }

    public static InscribePacket decode(FriendlyByteBuf buffer) {
        int n = buffer.readInt();
        ArrayList<Sign> runes = new ArrayList<Sign>();
        for (int i = 0; i < n; ++i) {
            runes.add(Signs.find(new ResourceLocation(buffer.m_130136_(255))));
        }
        return new InscribePacket(buffer.readInt(), runes);
    }

    public static void consume(InscribePacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            assert (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_SERVER);
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null || player.f_36096_.f_38840_ != packet.id) {
                return;
            }
            AbstractContainerMenu patt1768$temp = player.f_36096_;
            if (patt1768$temp instanceof ScriptoriumContainer) {
                ScriptoriumContainer container = (ScriptoriumContainer)patt1768$temp;
                container.setChant(packet.signs);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

