/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.datagen;

import com.google.gson.JsonElement;
import elucent.eidolon.Eidolon;
import elucent.eidolon.api.deity.Deity;
import elucent.eidolon.common.deity.Deities;
import elucent.eidolon.datagen.SimpleDataProvider;
import elucent.eidolon.recipe.ChantConversionRecipe;
import elucent.eidolon.registries.Registry;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EidChantConversionProvider
extends SimpleDataProvider {
    List<ChantConversionRecipe> chants = new ArrayList<ChantConversionRecipe>();

    public EidChantConversionProvider(DataGenerator dataGenerator) {
        super(dataGenerator);
    }

    @Override
    public void collectJsons(CachedOutput pOutput) {
        this.addConversions();
        for (ChantConversionRecipe recipe : this.chants) {
            Path path = EidChantConversionProvider.getRecipePath(this.output, recipe.m_6423_().m_135815_());
            this.saveStable(pOutput, (JsonElement)recipe.toJson(), path);
        }
    }

    protected void addConversions() {
        this.addConversion("convert_inlay_holy", Deities.LIGHT_DEITY, (Item)Registry.GOLD_INLAY.get(), ((Item)Registry.HOLY_SYMBOL.get()).m_7968_(), 10.0f);
        this.addConversion("convert_inlay_unholy", Deities.DARK_DEITY, (Item)Registry.PEWTER_INLAY.get(), ((Item)Registry.UNHOLY_SYMBOL.get()).m_7968_(), 10.0f);
        this.addConversion("convert_top_hat", null, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41938_}), ((Item)Registry.TOP_HAT.get()).m_7968_(), 0.0f);
        this.addConversion("convert_disc", null, Ingredient.m_204132_((TagKey)ItemTags.f_13158_), ((Item)Registry.PAROUSIA_DISC.get()).m_7968_(), 0.0f);
    }

    public void addConversion(String name, @Nullable Deity deity, Item input, ItemStack output, float minDevotion) {
        this.addConversion(name, deity, Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}), output, minDevotion);
    }

    public void addConversion(String name, @Nullable Deity deity, Ingredient input, ItemStack output, float minDevotion) {
        this.chants.add(new ChantConversionRecipe(Eidolon.prefix(name), input, output, minDevotion, deity == null ? null : deity.getId()));
    }

    protected static Path getRecipePath(Path pathIn, String str) {
        return pathIn.resolve("data/eidolon/recipes/" + str + ".json");
    }

    @NotNull
    public String m_6055_() {
        return "Eidolon Conversion Chants";
    }
}

