/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.world;

import com.mojang.serialization.Codec;
import elucent.eidolon.registries.Worldgen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockRotProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.jetbrains.annotations.NotNull;

public class EidolonAbstractTreeFeature
extends Feature<TreeConfiguration> {
    private static final ResourceLocation ILLWOOD_TREE1 = new ResourceLocation("eidolon:illwood_tree1");
    private static final ResourceLocation ILLWOOD_TREE2 = new ResourceLocation("eidolon:illwood_tree2");
    private static final ResourceLocation ILLWOOD_TREE3 = new ResourceLocation("eidolon:illwood_tree3");
    private static final ResourceLocation[] ILLWOOD_TREE = new ResourceLocation[]{ILLWOOD_TREE1, ILLWOOD_TREE2, ILLWOOD_TREE3};

    public EidolonAbstractTreeFeature(Codec<TreeConfiguration> codec) {
        super(codec);
    }

    public static boolean isAirOrLeavesAt(LevelSimulatedReader reader, BlockPos pos) {
        return reader.m_7433_(pos, state -> state.m_60795_() || state.m_204336_(BlockTags.f_13035_));
    }

    public static boolean isAirOrLeavesOrLogsAt(LevelSimulatedReader reader, BlockPos pos) {
        return reader.m_7433_(pos, state -> state.m_60795_() || state.m_204336_(BlockTags.f_13035_) || state.m_204336_(BlockTags.f_13106_));
    }

    private static boolean isDirtOrFarmlandAt(LevelSimulatedReader reader, BlockPos pos) {
        return reader.m_7433_(pos, state -> {
            Block block = state.m_60734_();
            return EidolonAbstractTreeFeature.m_159759_((BlockState)state) || block == Blocks.f_50093_;
        });
    }

    public boolean m_142674_(FeaturePlaceContext<TreeConfiguration> context) {
        WorldGenLevel reader = context.m_159774_();
        TreeConfiguration config = (TreeConfiguration)context.m_159778_();
        BlockPos pos = context.m_159777_();
        RandomSource rand = context.m_225041_();
        int i = rand.m_188503_(ILLWOOD_TREE.length);
        if (!EidolonAbstractTreeFeature.isDirtOrFarmlandAt((LevelSimulatedReader)reader, pos.m_7495_())) {
            return false;
        }
        for (int j = 0; j < 8; ++j) {
            BlockPos upPos = new BlockPos((Vec3i)pos).m_7494_();
            for (int k = 0; k < j; ++k) {
                upPos = upPos.m_7494_();
            }
            if (!EidolonAbstractTreeFeature.isAirOrLeavesOrLogsAt((LevelSimulatedReader)reader, upPos)) {
                return false;
            }
            if (!EidolonAbstractTreeFeature.isAirOrLeavesOrLogsAt((LevelSimulatedReader)reader, upPos.m_122012_())) {
                return false;
            }
            if (!EidolonAbstractTreeFeature.isAirOrLeavesOrLogsAt((LevelSimulatedReader)reader, upPos.m_122019_())) {
                return false;
            }
            if (!EidolonAbstractTreeFeature.isAirOrLeavesOrLogsAt((LevelSimulatedReader)reader, upPos.m_122029_())) {
                return false;
            }
            if (!EidolonAbstractTreeFeature.isAirOrLeavesOrLogsAt((LevelSimulatedReader)reader, upPos.m_122029_().m_122012_())) {
                return false;
            }
            if (!EidolonAbstractTreeFeature.isAirOrLeavesOrLogsAt((LevelSimulatedReader)reader, upPos.m_122029_().m_122019_())) {
                return false;
            }
            if (!EidolonAbstractTreeFeature.isAirOrLeavesOrLogsAt((LevelSimulatedReader)reader, upPos.m_122024_())) {
                return false;
            }
            if (!EidolonAbstractTreeFeature.isAirOrLeavesOrLogsAt((LevelSimulatedReader)reader, upPos.m_122024_().m_122012_())) {
                return false;
            }
            if (EidolonAbstractTreeFeature.isAirOrLeavesOrLogsAt((LevelSimulatedReader)reader, upPos.m_122024_().m_122019_())) continue;
            return false;
        }
        if (EidolonAbstractTreeFeature.isAirOrLeavesOrLogsAt((LevelSimulatedReader)reader, pos.m_7495_().m_122012_())) {
            return false;
        }
        if (EidolonAbstractTreeFeature.isAirOrLeavesOrLogsAt((LevelSimulatedReader)reader, pos.m_7495_().m_122019_())) {
            return false;
        }
        if (EidolonAbstractTreeFeature.isAirOrLeavesOrLogsAt((LevelSimulatedReader)reader, pos.m_7495_().m_122029_())) {
            return false;
        }
        if (EidolonAbstractTreeFeature.isAirOrLeavesOrLogsAt((LevelSimulatedReader)reader, pos.m_7495_().m_122024_())) {
            return false;
        }
        BlockRotProcessor BlockRotProcessor2 = new BlockRotProcessor(0.9f);
        StructureTemplateManager templatemanager = reader.m_6018_().m_7654_().m_236738_();
        StructureTemplate template = templatemanager.m_230359_(ILLWOOD_TREE[i]);
        Rotation rotation = Rotation.m_221990_((RandomSource)rand);
        BlockPos halfLengths = new BlockPos(template.m_163801_().m_123341_() / 2, template.m_163801_().m_123342_() / 2, template.m_163801_().m_123343_() / 2);
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos);
        StructurePlaceSettings placementsettings = new StructurePlaceSettings().m_74379_(rotation).m_74385_(halfLengths).m_74392_(false);
        BlockPos.MutableBlockPos pos1 = mutable.m_122190_((Vec3i)pos).m_122184_(-halfLengths.m_123341_(), 0, -halfLengths.m_123343_());
        template.m_230328_((ServerLevelAccessor)reader, (BlockPos)pos1, (BlockPos)pos1, placementsettings, rand, 2);
        return true;
    }

    public static class TreeGrower
    extends AbstractTreeGrower {
        protected ResourceKey<ConfiguredFeature<?, ?>> m_213888_(@NotNull RandomSource p_60014_, boolean p_60015_) {
            return Worldgen.ILLWOOD_TREE_CFG;
        }
    }
}

