/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.ritual;

import elucent.eidolon.api.ritual.IRitualItemFocus;
import elucent.eidolon.api.ritual.Ritual;
import elucent.eidolon.common.item.IRechargeableWand;
import elucent.eidolon.network.Networking;
import elucent.eidolon.network.RitualConsumePacket;
import elucent.eidolon.util.ColorUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class RechargingRitual
extends Ritual {
    public static final ResourceLocation SYMBOL = new ResourceLocation("eidolon", "particle/recharge_ritual");

    public RechargingRitual() {
        super(SYMBOL, ColorUtil.packColor(255, 220, 180, 701));
    }

    @Override
    public Ritual cloneRitual() {
        return new RechargingRitual();
    }

    @Override
    public Ritual.RitualResult start(Level world, BlockPos pos) {
        List<IRitualItemFocus> tiles = Ritual.getTilesWithinAABB(IRitualItemFocus.class, world, this.getSearchBounds(pos));
        if (!tiles.isEmpty()) {
            for (IRitualItemFocus tile : tiles) {
                ItemStack stack = tile.provide();
                if (!(stack.m_41720_() instanceof IRechargeableWand)) continue;
                tile.replace(((IRechargeableWand)stack.m_41720_()).recharge(stack));
                if (world.f_46443_ || !(tile instanceof BlockEntity)) break;
                BlockEntity b = (BlockEntity)tile;
                Networking.sendToTracking(world, b.m_58899_(), new RitualConsumePacket(pos.m_6630_(2), b.m_58899_(), this.getRed(), this.getGreen(), this.getBlue()));
                break;
            }
        }
        return Ritual.RitualResult.TERMINATE;
    }
}

