/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.ritual;

import elucent.eidolon.Eidolon;
import elucent.eidolon.api.ritual.IRitualItemFocus;
import elucent.eidolon.api.ritual.Ritual;
import elucent.eidolon.common.item.SummoningStaffItem;
import elucent.eidolon.common.spell.ThrallSpell;
import elucent.eidolon.network.MagicBurstEffectPacket;
import elucent.eidolon.network.Networking;
import elucent.eidolon.network.RitualConsumePacket;
import elucent.eidolon.util.ColorUtil;
import elucent.eidolon.util.EntityUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class AbsorptionRitual
extends Ritual {
    public static final ResourceLocation SYMBOL = new ResourceLocation("eidolon", "particle/absorption_ritual");

    public AbsorptionRitual() {
        super(SYMBOL, ColorUtil.packColor(255, 123, 140, 70));
    }

    @Override
    public Ritual cloneRitual() {
        return new AbsorptionRitual();
    }

    @Override
    public Ritual.RitualResult start(Level world, BlockPos pos) {
        if (world.f_46443_) {
            return Ritual.RitualResult.TERMINATE;
        }
        List<IRitualItemFocus> tiles = Ritual.getTilesWithinAABB(IRitualItemFocus.class, world, this.getSearchBounds(pos));
        BlockPos toRecharge = null;
        if (!tiles.isEmpty()) {
            for (IRitualItemFocus tile : tiles) {
                ItemStack stack = tile.provide();
                if (!(stack.m_41720_() instanceof SummoningStaffItem)) continue;
                toRecharge = ((BlockEntity)tile).m_58899_();
                break;
            }
        }
        List entities = world.m_6443_(LivingEntity.class, this.getSearchBounds(pos), e -> (Eidolon.getTrueMobType(e) == MobType.f_21641_ || e.m_6095_().m_204039_(ThrallSpell.ENTHRALL_WHITELIST)) && !e.m_6095_().m_204039_(ThrallSpell.ENTHRALL_BLACKLIST) && !(e instanceof Player) && !EntityUtil.isEnthralled(e) && e.m_21223_() <= e.m_21233_() / 3.0f);
        ListTag entityTags = new ListTag();
        for (LivingEntity e2 : entities) {
            e2.m_21153_(e2.m_21233_());
            Networking.sendToTracking(world, e2.m_20183_(), new MagicBurstEffectPacket(e2.m_20185_(), e2.m_20186_() + 0.1, e2.m_20189_(), ColorUtil.packColor(255, 61, 70, 35), ColorUtil.packColor(255, 36, 24, 41)));
            if (toRecharge != null) {
                Networking.sendToTracking(world, toRecharge, new RitualConsumePacket(e2.m_20183_().m_7494_(), toRecharge, this.getRed(), this.getGreen(), this.getBlue()));
            }
            CompoundTag eTag = e2.serializeNBT();
            entityTags.add((Object)eTag);
            e2.m_142687_(Entity.RemovalReason.KILLED);
        }
        if (!tiles.isEmpty()) {
            for (IRitualItemFocus tile : tiles) {
                ItemStack stack = tile.provide();
                Item item = stack.m_41720_();
                if (!(item instanceof SummoningStaffItem)) continue;
                SummoningStaffItem s = (SummoningStaffItem)item;
                tile.replace(s.addCharges(stack, entityTags));
                break;
            }
        }
        return Ritual.RitualResult.TERMINATE;
    }
}

