/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.incense;

import elucent.eidolon.api.altar.AltarInfo;
import elucent.eidolon.api.deity.Deity;
import elucent.eidolon.api.ritual.IncenseRitual;
import elucent.eidolon.api.ritual.Ritual;
import elucent.eidolon.capability.IReputation;
import elucent.eidolon.client.particle.Particles;
import elucent.eidolon.common.deity.Deities;
import elucent.eidolon.common.deity.DeityLocks;
import elucent.eidolon.common.spell.PrayerSpell;
import elucent.eidolon.common.tile.CenserTileEntity;
import elucent.eidolon.common.tile.EffigyTileEntity;
import elucent.eidolon.registries.EidolonParticles;
import elucent.eidolon.registries.Spells;
import elucent.eidolon.util.KnowledgeUtil;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;

public class PrayerIncense
extends IncenseRitual {
    public PrayerIncense(ResourceLocation registryName) {
        super(800, registryName);
    }

    @Override
    public boolean start(@Nullable Player player, CenserTileEntity censer) {
        super.start(player, censer);
        Level world = censer.m_58904_();
        BlockPos pos = censer.m_58899_();
        if (world == null || player == null) {
            return false;
        }
        LazyOptional reputationLazyOptional = world.getCapability(IReputation.INSTANCE);
        if (!reputationLazyOptional.isPresent() || reputationLazyOptional.resolve().isEmpty()) {
            return false;
        }
        if (!((IReputation)reputationLazyOptional.resolve().get()).canPray(player, Spells.CENSER, world.m_46467_())) {
            player.m_5661_((Component)Component.m_237115_((String)"eidolon.message.prayer_cooldown"), true);
            return false;
        }
        List<EffigyTileEntity> effigies = Ritual.getTilesWithinAABB(EffigyTileEntity.class, world, new AABB(pos.m_7918_(-4, -4, -4), pos.m_7918_(5, 5, 5)));
        if (effigies.isEmpty()) {
            player.m_5661_((Component)Component.m_237115_((String)"eidolon.message.no_effigy"), true);
            return false;
        }
        EffigyTileEntity effigy = effigies.stream().min(Comparator.comparingDouble(e -> e.m_58899_().m_123331_((Vec3i)pos))).get();
        if (effigy.ready()) {
            Deity deity = Deities.LIGHT_DEITY;
            AltarInfo info = AltarInfo.getAltarInfo(world, effigy.m_58899_());
            world.getCapability(IReputation.INSTANCE, null).ifPresent(rep -> {
                if (rep.getReputation(player, deity.getId()) < 3.0) {
                    player.m_5661_((Component)Component.m_237115_((String)"eidolon.message.not_enough_reputation"), true);
                    return;
                }
                KnowledgeUtil.grantResearchNoToast((Entity)player, DeityLocks.BASIC_INCENSE_PRAYER);
                rep.pray(player, Spells.CENSER, world.m_46467_());
                rep.addReputation(player, deity.getId(), 2.0 + 0.5 * info.getPower());
                PrayerSpell.updateMagic(info, player, world, rep.getReputation(player, deity.getId()));
            });
            return true;
        }
        return false;
    }

    @Override
    public void animateParticles(int burnCounter, BlockPos blockPos, Level level) {
        float x = (float)blockPos.m_123341_() + 0.5f;
        float y = (float)blockPos.m_123342_() + 0.45f;
        float z = (float)blockPos.m_123343_() + 0.5f;
        float r = this.getRed();
        float g = this.getGreen();
        float b = this.getBlue();
        if (burnCounter < 160) {
            Particles.create(EidolonParticles.FLAME_PARTICLE).setAlpha(0.5f, 0.0f).setScale(0.25f, 0.125f).setLifetime(20).randomOffset(0.125, 0.125).randomVelocity(0.00625f, 0.01875f).addVelocity(0.0, 0.00625f, 0.0).setColor(r, g, b, r, g * 0.5f, b * 1.5f).spawn(level, x, y, z);
        }
        assert (level != null);
        if (level.f_46441_.m_188503_(20) == 0) {
            Particles.create(EidolonParticles.SPARKLE_PARTICLE).setAlpha(1.0f, 0.0f).setScale(0.0625f, 0.0f).setLifetime(40).randomOffset(0.0625, 0.0).randomVelocity(0.125, 0.0).addVelocity(0.0, 0.125, 0.0).setColor(r, g * 1.5f, b * 2.0f, r, g, b).enableGravity().setSpin(0.4f).spawn(level, x, y, z);
        }
        if (level.f_46441_.m_188503_(5) == 0) {
            Particles.create(EidolonParticles.SMOKE_PARTICLE).setAlpha(0.25f, 0.0f).setScale(0.375f, 0.125f).setLifetime(160).randomOffset(0.25, 0.125).randomVelocity(0.025f, 0.025f).addVelocity(0.0, 0.0125f, 0.0).setColor(0.75f, 0.75f, 0.75f, 0.25f, 0.25f, 0.25f).spawn(level, x, (double)y + 0.125, z);
        }
        if (level.f_46441_.m_188503_(5) == 0) {
            Particles.createRune(ResourceLocation.m_135820_((String)"eidolon:purity")).setAlpha(0.75f, 0.0f).setScale(0.475f, 0.25f).setLifetime(160).randomOffset((double)this.range() * 0.15, 0.25).randomVelocity(0.025f, 0.025f).addVelocity(0.0, -0.0125f, 0.0).setColor(0.95f, 0.95f, 0.95f, 0.005f, 0.005f, 0.005f).repeat(level, x, (double)y + 0.75, z, 2);
        }
    }
}

