/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.common.entity;

import elucent.eidolon.datagen.EidBiomeTagProvider;
import elucent.eidolon.registries.EidolonEntities;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SlimySlugEntity
extends TamableAnimal {
    private static final Ingredient TEMPTATION_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42577_});
    float yRotTrail = 0.0f;
    public float squishAmount = 1.0f;
    public int slimeTime = this.f_19796_.m_188503_(12000) + 12000;
    public static final EntityDataAccessor<Integer> TYPE = SynchedEntityData.m_135353_(SlimySlugEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public SlimySlugEntity(EntityType<SlimySlugEntity> type, Level worldIn) {
        super(type, worldIn);
        this.m_8099_();
        this.yRotTrail = this.m_146908_();
        this.m_20088_().m_135381_(TYPE, (Object)0);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, @NotNull DifficultyInstance pDifficulty, @NotNull MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        Holder holder = pLevel.m_204166_(this.m_20183_());
        if (holder.m_203656_(EidBiomeTagProvider.BROWN_SLUG_TAG)) {
            this.setVariant(2);
        } else if (holder.m_203656_(EidBiomeTagProvider.BANANA_SLUG_TAG)) {
            this.setVariant(1);
        } else {
            this.setVariant(0);
        }
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    @Nullable
    public SlimySlugEntity getBreedOffspring(@NotNull ServerLevel serverLevel, @NotNull AgeableMob ageableMob) {
        SlimySlugEntity offspring = (SlimySlugEntity)((EntityType)EidolonEntities.SLIMY_SLUG.get()).m_20615_((Level)serverLevel);
        if (offspring != null) {
            Holder holder = serverLevel.m_204166_(this.m_20183_());
            if (holder.m_203656_(EidBiomeTagProvider.BROWN_SLUG_TAG)) {
                offspring.setVariant(2);
            } else if (holder.m_203656_(EidBiomeTagProvider.BANANA_SLUG_TAG)) {
                offspring.setVariant(1);
            } else {
                offspring.setVariant(0);
            }
        }
        return offspring;
    }

    private void setVariant(int type) {
        this.m_20088_().m_135381_(TYPE, (Object)type);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(TYPE, (Object)0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 10, true, false, e -> e.m_6844_(EquipmentSlot.HEAD).m_41720_().equals(Items.f_42047_)));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.4));
        this.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 5.0f, 1.0f, true));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, TEMPTATION_ITEMS, false));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public boolean m_6898_(@NotNull ItemStack pStack) {
        return TEMPTATION_ITEMS.test(pStack);
    }

    public static AttributeSupplier createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22279_, (double)0.1f).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22281_, 999.0).m_22265_();
    }

    public void m_8119_() {
        super.m_8119_();
        this.yRotTrail = Mth.m_14189_((float)this.yRotTrail, (float)this.m_146908_(), (float)0.2f);
    }

    @NotNull
    public InteractionResult m_6071_(Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_41720_() == Items.f_42577_) {
            if (!this.m_21824_()) {
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                if (!this.f_19853_.f_46443_) {
                    if (this.f_19796_.m_188503_(10) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
                        this.m_21828_(player);
                        this.f_19853_.m_7605_((Entity)this, (byte)7);
                    } else {
                        this.f_19853_.m_7605_((Entity)this, (byte)6);
                    }
                }
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
            return super.m_6071_(player, hand);
        }
        if (this.m_20096_() && this.m_21824_() && this.m_21830_((LivingEntity)player)) {
            if (!this.f_19853_.f_46443_) {
                this.m_21839_(!this.m_21827_());
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.f_46443_ && this.m_6084_() && !this.m_6162_() && --this.slimeTime <= 0) {
            this.m_5496_(SoundEvents.f_12388_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
            this.m_19998_((ItemLike)Items.f_42518_);
            this.slimeTime = this.f_19796_.m_188503_(12000) + 12000;
        }
    }
}

