/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.codex;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import elucent.eidolon.api.spells.Sign;
import elucent.eidolon.capability.IKnowledge;
import elucent.eidolon.client.ClientRegistry;
import elucent.eidolon.codex.Chapter;
import elucent.eidolon.codex.CodexGui;
import elucent.eidolon.codex.Page;
import elucent.eidolon.registries.EidolonSounds;
import elucent.eidolon.util.ClientInfo;
import elucent.eidolon.util.RenderUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class SignIndexPage
extends Page {
    public static final ResourceLocation BACKGROUND = new ResourceLocation("eidolon", "textures/gui/codex_sign_index_page.png");
    final List<SignEntry> entries = new ArrayList<SignEntry>();

    public SignIndexPage(SignEntry ... pages) {
        super(BACKGROUND);
        this.entries.addAll(List.of(pages));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean click(CodexGui gui, int x, int y, int mouseX, int mouseY) {
        LocalPlayer entity = Minecraft.m_91087_().f_91074_;
        IKnowledge knowledge = (IKnowledge)entity.getCapability(IKnowledge.INSTANCE, null).resolve().get();
        for (int i = 0; i < this.entries.size(); ++i) {
            int xx = x + 8 + i % 2 * 56;
            int yy = y + 4 + i / 2 * 52;
            if (knowledge.knowsSign(this.entries.get((int)i).sign) && mouseX >= xx + 38 && mouseY >= yy + 38 && mouseX <= xx + 50 && mouseY <= yy + 50) {
                gui.changeChapter(this.entries.get((int)i).chapter);
                Minecraft.m_91087_().f_91074_.m_6330_((SoundEvent)SoundEvents.f_12490_.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                return true;
            }
            if (!knowledge.knowsSign(this.entries.get((int)i).sign) || mouseX < xx || mouseX > xx + 48 || mouseY < yy || mouseY > yy + 48) continue;
            gui.addToChant(this.entries.get((int)i).sign);
            entity.m_6330_((SoundEvent)EidolonSounds.SELECT_RUNE.get(), SoundSource.NEUTRAL, 0.5f, entity.f_19853_.f_46441_.m_188501_() * 0.25f + 0.75f);
            return true;
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(CodexGui gui, @NotNull GuiGraphics guiGraphics, ResourceLocation bg, int x, int y, int mouseX, int mouseY) {
        LocalPlayer entity = Minecraft.m_91087_().f_91074_;
        if (entity == null) {
            return;
        }
        IKnowledge knowledge = (IKnowledge)entity.getCapability(IKnowledge.INSTANCE, null).resolve().get();
        PoseStack mStack = guiGraphics.m_280168_();
        for (int i = 0; i < this.entries.size(); ++i) {
            int xx = x + 8 + i % 2 * 56;
            int yy = y + 4 + i / 2 * 52;
            Sign sign = this.entries.get((int)i).sign;
            boolean hover = knowledge.knowsSign(sign) && mouseX >= xx && mouseX <= xx + 48 && mouseY >= yy && mouseY <= yy + 48;
            boolean infoHover = knowledge.knowsSign(sign) && mouseX >= xx + 38 && mouseY >= yy + 38 && mouseX <= xx + 50 && mouseY <= yy + 50;
            guiGraphics.m_280218_(BACKGROUND, xx, yy, knowledge.knowsSign(this.entries.get((int)i).sign) ? 128 : 176, 0, 48, 48);
            if (!knowledge.knowsSign(sign)) continue;
            MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            RenderSystem.setShader(ClientRegistry::getGlowingSpriteShader);
            if (hover && !infoHover) {
                mStack.m_85836_();
                mStack.m_252880_((float)(xx + 24), (float)(yy + 24), 0.0f);
                mStack.m_252781_(Axis.f_252403_.m_252977_(ClientInfo.getClientPartialTicks() * 1.5f));
                SignIndexPage.colorBlit(mStack, -18, -18, 128, 48, 36, 36, 256, 256, sign.getColor());
                mStack.m_85849_();
            }
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
            for (int j = 0; j < (hover && !infoHover ? 2 : 1); ++j) {
                RenderUtil.litQuad(mStack, (MultiBufferSource)bufferSource, xx + 12, yy + 12, 24.0, 24.0, sign.getRed(), sign.getGreen(), sign.getBlue(), (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(sign.getSprite()));
                bufferSource.m_109911_();
            }
            RenderSystem.disableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.setShader(GameRenderer::m_172817_);
            guiGraphics.m_280218_(BACKGROUND, xx + 38, yy + 38, infoHover ? 188 : 176, 48, 12, 14);
            if (!infoHover) continue;
            guiGraphics.m_280557_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237110_((String)"eidolon.codex.sign_suffix", (Object[])new Object[]{Component.m_237115_((String)(sign.getRegistryName().m_135827_() + ".sign." + sign.getRegistryName().m_135815_()))}), mouseX, mouseY);
        }
    }

    public static class SignEntry {
        final Chapter chapter;
        final Sign sign;

        public SignEntry(Chapter chapter, Sign sign) {
            this.chapter = chapter;
            this.sign = sign;
        }
    }
}

