/*
 * Decompiled with CFR 0.152.
 */
package elucent.eidolon.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import elucent.eidolon.capability.IPlayerData;
import elucent.eidolon.capability.ISoul;
import elucent.eidolon.client.ClientConfig;
import elucent.eidolon.client.model.BruteSkeletonModel;
import elucent.eidolon.client.model.NecromancerModel;
import elucent.eidolon.client.model.RavenModel;
import elucent.eidolon.client.model.SlimySlugModel;
import elucent.eidolon.client.model.WraithModel;
import elucent.eidolon.client.model.ZombieBruteModel;
import elucent.eidolon.client.renderer.ChantCasterRenderer;
import elucent.eidolon.client.renderer.GiantSkeletonRenderer;
import elucent.eidolon.client.renderer.NecromancerRenderer;
import elucent.eidolon.client.renderer.RavenRenderer;
import elucent.eidolon.client.renderer.SlimySlugRenderer;
import elucent.eidolon.client.renderer.WraithRenderer;
import elucent.eidolon.client.renderer.ZombieBruteRenderer;
import elucent.eidolon.common.item.ChantScrollItem;
import elucent.eidolon.common.item.IManaRelatedItem;
import elucent.eidolon.common.item.IWingsItem;
import elucent.eidolon.common.item.curio.RavenCloakRenderer;
import elucent.eidolon.common.item.curio.SanguineAmuletItem;
import elucent.eidolon.common.item.model.BonelordArmorModel;
import elucent.eidolon.common.item.model.RavenCloakModel;
import elucent.eidolon.common.item.model.SilverArmorModel;
import elucent.eidolon.common.item.model.TopHatModel;
import elucent.eidolon.common.item.model.WarlockArmorModel;
import elucent.eidolon.common.tile.CrucibleTileRenderer;
import elucent.eidolon.event.ClientEvents;
import elucent.eidolon.registries.EidolonEntities;
import elucent.eidolon.registries.EidolonPotions;
import elucent.eidolon.registries.Registry;
import java.io.IOException;
import java.util.Random;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.entity.NoopRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;

@Mod.EventBusSubscriber(modid="eidolon", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientRegistry {
    public static final ModelLayerLocation SILVER_ARMOR_LAYER = new ModelLayerLocation(new ResourceLocation("eidolon", "silver_armor"), "main");
    public static final ModelLayerLocation WARLOCK_ARMOR_LAYER = new ModelLayerLocation(new ResourceLocation("eidolon", "warlock_armor"), "main");
    public static final ModelLayerLocation BONELORD_ARMOR_LAYER = new ModelLayerLocation(new ResourceLocation("eidolon", "bonelord_armor"), "main");
    public static final ModelLayerLocation TOP_HAT_LAYER = new ModelLayerLocation(new ResourceLocation("eidolon", "top_hat"), "main");
    public static final ModelLayerLocation RAVEN_LAYER = new ModelLayerLocation(new ResourceLocation("eidolon", "raven"), "main");
    public static final ModelLayerLocation NECROMANCER_LAYER = new ModelLayerLocation(new ResourceLocation("eidolon", "necromancer"), "main");
    public static final ModelLayerLocation WRAITH_LAYER = new ModelLayerLocation(new ResourceLocation("eidolon", "wraith"), "main");
    public static final ModelLayerLocation ZOMBIE_BRUTE_LAYER = new ModelLayerLocation(new ResourceLocation("eidolon", "zombie_brute"), "main");
    public static final ModelLayerLocation SLUG_LAYER = new ModelLayerLocation(new ResourceLocation("eidolon", "slimy_slug"), "main");
    public static final ModelLayerLocation GIANT_SKEL_LAYER = new ModelLayerLocation(new ResourceLocation("eidolon", "giant_skeleton"), "main");
    public static final ModelLayerLocation CRUCIBLE_STIRRER_LAYER = new ModelLayerLocation(new ResourceLocation("eidolon", "crucible_stirrer"), "main");
    public static final ModelLayerLocation RAVEN_CLOAK_LAYER = new ModelLayerLocation(new ResourceLocation("eidolon", "raven_cloak"), "main");
    public static WarlockArmorModel WARLOCK_ARMOR_MODEL = null;
    public static BonelordArmorModel BONELORD_ARMOR_MODEL = null;
    public static TopHatModel TOP_HAT_MODEL = null;
    public static SilverArmorModel SILVER_ARMOR_MODEL = null;
    public static ZombieBruteModel ZOMBIE_BRUTE_MODEL = null;
    public static BruteSkeletonModel GIANT_SKEL_MODEL = null;
    public static WraithModel WRAITH_MODEL = null;
    public static RavenModel RAVEN_MODEL = null;
    public static NecromancerModel NECROMANCER_MODEL = null;
    public static SlimySlugModel SLUG_MODEL = null;
    public static ShaderInstance GLOWING_SHADER;
    public static ShaderInstance GLOWING_SPRITE_SHADER;
    public static ShaderInstance GLOWING_PARTICLE_SHADER;
    public static ShaderInstance VAPOR_SHADER;
    public static ShaderInstance GLOWING_ENTITY_SHADER;
    public static ShaderInstance SPRITE_PARTICLE_SHADER;
    protected static final ResourceLocation ICONS_TEXTURE;
    protected static final ResourceLocation MANA_BAR_TEXTURE;

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void registerTooltip(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(SanguineAmuletItem.SanguineAmuletTooltipInfo.class, SanguineAmuletItem.SanguineAmuletTooltipComponent::new);
        event.register(ChantScrollItem.ChantTooltipInfo.class, ChantScrollItem.ChantTooltipComponent::new);
    }

    @SubscribeEvent
    public static void onRegisterLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(WARLOCK_ARMOR_LAYER, WarlockArmorModel::createBodyLayer);
        event.registerLayerDefinition(BONELORD_ARMOR_LAYER, BonelordArmorModel::createBodyLayer);
        event.registerLayerDefinition(TOP_HAT_LAYER, TopHatModel::createBodyLayer);
        event.registerLayerDefinition(SILVER_ARMOR_LAYER, SilverArmorModel::createBodyLayer);
        event.registerLayerDefinition(RAVEN_CLOAK_LAYER, RavenCloakModel::createBodyLayer);
        event.registerLayerDefinition(RAVEN_LAYER, RavenModel::createBodyLayer);
        event.registerLayerDefinition(ZOMBIE_BRUTE_LAYER, ZombieBruteModel::createBodyLayer);
        event.registerLayerDefinition(WRAITH_LAYER, WraithModel::createBodyLayer);
        event.registerLayerDefinition(NECROMANCER_LAYER, NecromancerModel::createBodyLayer);
        event.registerLayerDefinition(SLUG_LAYER, SlimySlugModel::createBodyLayer);
        event.registerLayerDefinition(GIANT_SKEL_LAYER, BruteSkeletonModel::createBodyLayer);
        event.registerLayerDefinition(CRUCIBLE_STIRRER_LAYER, CrucibleTileRenderer::createModelLayer);
    }

    @SubscribeEvent
    public static void onRegisterLayers(EntityRenderersEvent.AddLayers event) {
        WARLOCK_ARMOR_MODEL = new WarlockArmorModel(event.getEntityModels().m_171103_(WARLOCK_ARMOR_LAYER));
        BONELORD_ARMOR_MODEL = new BonelordArmorModel(event.getEntityModels().m_171103_(BONELORD_ARMOR_LAYER));
        TOP_HAT_MODEL = new TopHatModel(event.getEntityModels().m_171103_(TOP_HAT_LAYER));
        SILVER_ARMOR_MODEL = new SilverArmorModel(event.getEntityModels().m_171103_(SILVER_ARMOR_LAYER));
        RAVEN_MODEL = new RavenModel(event.getEntityModels().m_171103_(RAVEN_LAYER));
        ZOMBIE_BRUTE_MODEL = new ZombieBruteModel(event.getEntityModels().m_171103_(ZOMBIE_BRUTE_LAYER));
        GIANT_SKEL_MODEL = new BruteSkeletonModel(event.getEntityModels().m_171103_(GIANT_SKEL_LAYER));
        WRAITH_MODEL = new WraithModel(event.getEntityModels().m_171103_(WRAITH_LAYER));
        NECROMANCER_MODEL = new NecromancerModel(event.getEntityModels().m_171103_(NECROMANCER_LAYER));
        SLUG_MODEL = new SlimySlugModel(event.getEntityModels().m_171103_(SLUG_LAYER));
    }

    @SubscribeEvent
    public static void onRegisterEntityRenders(EntityRenderersEvent.RegisterRenderers event) {
        EntityRenderers.m_174036_((EntityType)((EntityType)EidolonEntities.ZOMBIE_BRUTE.get()), ZombieBruteRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)EidolonEntities.GIANT_SKEL.get()), GiantSkeletonRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)EidolonEntities.WRAITH.get()), WraithRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)EidolonEntities.NECROMANCER.get()), NecromancerRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)EidolonEntities.SOULFIRE_PROJECTILE.get()), NoopRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)EidolonEntities.BONECHILL_PROJECTILE.get()), NoopRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)EidolonEntities.NECROMANCER_SPELL.get()), NoopRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)EidolonEntities.CHANT_CASTER.get()), ChantCasterRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)EidolonEntities.RAVEN.get()), RavenRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)EidolonEntities.SLIMY_SLUG.get()), SlimySlugRenderer::new);
    }

    public static ShaderInstance getGlowingShader() {
        return GLOWING_SHADER;
    }

    public static ShaderInstance getGlowingSpriteShader() {
        return GLOWING_SPRITE_SHADER;
    }

    public static ShaderInstance getGlowingParticleShader() {
        return GLOWING_PARTICLE_SHADER;
    }

    public static ShaderInstance getGlowingEntityShader() {
        return GLOWING_ENTITY_SHADER;
    }

    public static ShaderInstance getVaporShader() {
        return VAPOR_SHADER;
    }

    public static ShaderInstance getSpriteParticleShader() {
        return SPRITE_PARTICLE_SHADER;
    }

    @SubscribeEvent
    public static void shaderRegistry(RegisterShadersEvent event) throws IOException {
        event.registerShader(new ShaderInstance(event.getResourceProvider(), new ResourceLocation("eidolon:glowing"), DefaultVertexFormat.f_85815_), shader -> {
            GLOWING_SHADER = shader;
        });
        event.registerShader(new ShaderInstance(event.getResourceProvider(), new ResourceLocation("eidolon:glowing_sprite"), DefaultVertexFormat.f_85819_), shader -> {
            GLOWING_SPRITE_SHADER = shader;
        });
        event.registerShader(new ShaderInstance(event.getResourceProvider(), new ResourceLocation("eidolon:glowing_particle"), DefaultVertexFormat.f_85813_), shader -> {
            GLOWING_PARTICLE_SHADER = shader;
        });
        event.registerShader(new ShaderInstance(event.getResourceProvider(), new ResourceLocation("eidolon:glowing_entity"), DefaultVertexFormat.f_85812_), shader -> {
            GLOWING_ENTITY_SHADER = shader;
        });
        event.registerShader(new ShaderInstance(event.getResourceProvider(), new ResourceLocation("eidolon:vapor"), DefaultVertexFormat.f_85811_), shader -> {
            VAPOR_SHADER = shader;
        });
        event.registerShader(new ShaderInstance(event.getResourceProvider(), new ResourceLocation("eidolon:sprite_particle"), DefaultVertexFormat.f_85813_), shader -> {
            SPRITE_PARTICLE_SHADER = shader;
        });
    }

    public static void initCurios() {
        CuriosRendererRegistry.register((Item)((Item)Registry.RAVEN_CLOAK.get()), RavenCloakRenderer::new);
    }

    static {
        ICONS_TEXTURE = new ResourceLocation("eidolon", "textures/gui/icons.png");
        MANA_BAR_TEXTURE = new ResourceLocation("eidolon", "textures/gui/mana_bar.png");
    }

    public static class EidolonRavenCharge
    implements IGuiOverlay {
        protected static final ResourceLocation GUI_ICONS_LOCATION = new ResourceLocation("textures/gui/icons.png");

        public void render(ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
            PoseStack mStack = guiGraphics.m_280168_();
            Minecraft mc = gui.getMinecraft();
            LocalPlayer player = mc.f_91074_;
            if (!gui.shouldDrawSurvivalElements() || player == null || player.m_20096_()) {
                return;
            }
            player.getCapability(IPlayerData.INSTANCE).ifPresent(d -> {
                ItemStack wings = d.getWingsItem((Player)player);
                Item patt24608$temp = wings.m_41720_();
                if (!(patt24608$temp instanceof IWingsItem)) {
                    return;
                }
                IWingsItem wing = (IWingsItem)patt24608$temp;
                int remainingFlaps = d.getWingCharges((Player)player);
                String s = "" + remainingFlaps;
                int i1 = (screenWidth - gui.m_93082_().m_92895_(s)) / 2;
                int j1 = screenHeight - 46;
                guiGraphics.m_280056_(gui.m_93082_(), s, i1 + 1, j1, 0, false);
                guiGraphics.m_280056_(gui.m_93082_(), s, i1 - 1, j1, 0, false);
                guiGraphics.m_280056_(gui.m_93082_(), s, i1, j1 + 1, 0, false);
                guiGraphics.m_280056_(gui.m_93082_(), s, i1, j1 - 1, 0, false);
                guiGraphics.m_280056_(gui.m_93082_(), s, i1, j1, 6505166, false);
                if (ClientEvents.jumpTicks >= 5) {
                    gui.setupOverlayRenderState(false, false);
                    int x = screenWidth / 2 - 91;
                    guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
                    mc.m_91307_().m_6180_("ravenJumpBar");
                    float f = ((float)(ClientEvents.jumpTicks - 5) + Minecraft.m_91087_().m_91296_()) / 15.0f;
                    int i = 182;
                    int j = (int)(f * 183.0f);
                    int k = guiGraphics.m_280206_() - 32 + 3;
                    guiGraphics.m_280218_(GUI_ICONS_LOCATION, x, k, 0, 84, 182, 5);
                    if (j > 0) {
                        guiGraphics.m_280218_(GUI_ICONS_LOCATION, x, k, 0, 89, j, 5);
                    }
                    mc.m_91307_().m_7238_();
                    RenderSystem.enableBlend();
                    gui.getMinecraft().m_91307_().m_7238_();
                    guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
                }
            });
        }
    }

    public static class EidolonHearts
    implements IGuiOverlay {
        float lastEtherealHealth = 0.0f;
        long healthBlinkTime = 0L;
        long lastHealthTime = 0L;

        public void render(ForgeGui gui, GuiGraphics guiGraphics, float partialTicks, int width, int height) {
            int y;
            int x;
            int heart;
            int row;
            int i;
            boolean highlight;
            PoseStack mStack = guiGraphics.m_280168_();
            Minecraft mc = Minecraft.m_91087_();
            LocalPlayer player = mc.f_91074_;
            if (!gui.shouldDrawSurvivalElements() || player == null) {
                return;
            }
            mStack.m_85836_();
            mStack.m_85837_(0.0, 0.0, 0.01);
            int health = Mth.m_14167_((float)player.m_21223_());
            float absorb = Mth.m_14167_((float)player.m_6103_());
            AttributeInstance attrMaxHealth = player.m_21051_(Attributes.f_22276_);
            float healthMax = (float)attrMaxHealth.m_22135_();
            float etherealHealth = 0.0f;
            float etherealMax = 0.0f;
            try {
                ISoul cap = (ISoul)player.getCapability(ISoul.INSTANCE).resolve().orElseThrow();
                etherealHealth = cap.getEtherealHealth();
                etherealMax = cap.getMaxEtherealHealth();
            }
            catch (Exception cap) {
                // empty catch block
            }
            int ticks = gui.m_93079_();
            boolean bl = highlight = this.healthBlinkTime > (long)ticks && (this.healthBlinkTime - (long)ticks) / 3L % 2L == 1L;
            if (etherealHealth < this.lastEtherealHealth && player.f_19802_ > 0) {
                this.lastHealthTime = Util.m_137550_();
                this.healthBlinkTime = ticks + 20;
            } else if (etherealHealth > this.lastEtherealHealth) {
                this.lastHealthTime = Util.m_137550_();
                this.healthBlinkTime = ticks + 10;
            }
            if (Util.m_137550_() - this.lastHealthTime > 1000L) {
                this.lastEtherealHealth = health;
                this.lastHealthTime = Util.m_137550_();
            }
            this.lastEtherealHealth = etherealHealth;
            float f = Math.max((float)player.m_21133_(Attributes.f_22276_), (float)health);
            int regen = -1;
            if (player.m_21023_(MobEffects.f_19605_)) {
                regen = ticks % Mth.m_14167_((float)(f + 5.0f));
            }
            Random rand = new Random();
            rand.setSeed((long)ticks * 312871L);
            int absorptionHearts = Mth.m_14167_((float)(absorb / 2.0f)) - 1;
            int hearts = Mth.m_14167_((float)(healthMax / 2.0f)) - 1;
            int ethHearts = Mth.m_14167_((float)(etherealMax / 2.0f));
            int healthRows = Mth.m_14167_((float)((healthMax + absorb) / 2.0f / 10.0f));
            int totalHealthRows = Mth.m_14167_((float)((healthMax + absorb + etherealMax) / 2.0f / 10.0f));
            int rowHeight = Math.max(10 - (healthRows - 2), 3);
            int extraHealthRows = totalHealthRows - healthRows;
            int extraRowHeight = Mth.m_14045_((int)(10 - (healthRows - 2)), (int)3, (int)10);
            int left = width / 2 - 91;
            int top = height - ((ForgeGui)Minecraft.m_91087_().f_91065_).leftHeight + healthRows * rowHeight;
            if (rowHeight != 10) {
                top += 10 - rowHeight;
            }
            gui.leftHeight += extraHealthRows * extraRowHeight;
            for (i = absorptionHearts + hearts + ethHearts; i > absorptionHearts + hearts; --i) {
                row = (i + 1) / 10;
                heart = (i + 1) % 10;
                x = left + heart * 8;
                y = top - extraRowHeight * Math.max(0, row - healthRows + 1) - rowHeight * Math.min(row, healthRows - 1);
                guiGraphics.m_280218_(ICONS_TEXTURE, x, y, highlight ? 9 : 0, 18, 9, 9);
            }
            for (i = absorptionHearts + hearts + ethHearts; i > absorptionHearts + hearts; --i) {
                row = (i + 1) / 10;
                heart = (i + 1) % 10;
                x = left + heart * 8;
                y = top - extraRowHeight * Math.max(0, row - healthRows + 1) - rowHeight * Math.min(row, healthRows - 1);
                int i2 = i - (Mth.m_14167_((float)((healthMax + absorb) / 2.0f)) - 1);
                if ((float)(i2 * 2 + 1) < etherealHealth) {
                    guiGraphics.m_280218_(ICONS_TEXTURE, x, y, 0, 9, 9, 9);
                    continue;
                }
                if ((float)(i2 * 2 + 1) != etherealHealth) continue;
                guiGraphics.m_280218_(ICONS_TEXTURE, x, y, 9, 9, 9, 9);
            }
            for (i = Mth.m_14167_((float)((healthMax + absorb) / 2.0f)) - 1; i >= 0; --i) {
                row = i / 10;
                heart = i % 10;
                x = left + heart * 8;
                y = top - row * rowHeight;
                if (health <= 4) {
                    y += rand.nextInt(2);
                }
                if (i == regen) {
                    y -= 2;
                }
                RenderSystem.enableBlend();
                if (player.m_21023_((MobEffect)EidolonPotions.CHILLED_EFFECT.get()) && i <= Mth.m_14167_((float)(healthMax / 2.0f)) - 1) {
                    if (i * 2 + 1 < health) {
                        guiGraphics.m_280218_(ICONS_TEXTURE, x, y, 0, 0, 9, 9);
                    } else if (i * 2 + 1 == health) {
                        guiGraphics.m_280218_(ICONS_TEXTURE, x, y, 9, 0, 9, 9);
                    }
                }
                RenderSystem.disableBlend();
            }
            mStack.m_85849_();
        }
    }

    public static class EidolonManaBar
    implements IGuiOverlay {
        int xPos() {
            String origin = (String)ClientConfig.MANA_BAR_POSITION.get();
            if (origin.equals("bottomLeft") || origin.equals("left") || origin.equals("topLeft")) {
                return -1;
            }
            if (origin.equals("bottomRight") || origin.equals("right") || origin.equals("topRight")) {
                return 1;
            }
            return 0;
        }

        int yPos() {
            String origin = (String)ClientConfig.MANA_BAR_POSITION.get();
            if (origin.equals("top") || origin.equals("topLeft")) {
                return -1;
            }
            if (origin.equals("bottomLeft") || origin.equals("bottomRight")) {
                return 1;
            }
            return 0;
        }

        boolean horiz() {
            String orient = (String)ClientConfig.MANA_BAR_ORIENTATION.get();
            String origin = (String)ClientConfig.MANA_BAR_POSITION.get();
            if (orient.equals("horizontal")) {
                return true;
            }
            if (orient.equals("vertical")) {
                return false;
            }
            return !origin.equals("left") && !origin.equals("right");
        }

        public void render(ForgeGui gui, GuiGraphics guiGraphics, float partialTicks, int width, int height) {
            Minecraft mc = Minecraft.m_91087_();
            LocalPlayer player = mc.f_91074_;
            PoseStack mStack = guiGraphics.m_280168_();
            if (player == null) {
                return;
            }
            int xp = this.xPos();
            int yp = this.yPos();
            boolean isHoriz = this.horiz();
            int w = isHoriz ? 120 : 28;
            int h = isHoriz ? 28 : 120;
            int ox = width / 2 - w / 2;
            int oy = height / 2 - h / 2;
            if (isHoriz) {
                if (yp == -1) {
                    oy = 4;
                } else if (yp == 1) {
                    oy = height + 4 - h;
                }
                if (xp == -1) {
                    ox = 8;
                } else if (xp == 1) {
                    ox = width - 4 - w;
                }
            } else {
                if (yp == -1) {
                    oy = -8;
                } else if (yp == 1) {
                    oy = height - 20 - h;
                }
                if (xp == -1) {
                    ox = 4;
                } else if (xp == 1) {
                    ox = width + 4 - w;
                }
            }
            int barlength = 114;
            float magic = 0.0f;
            float maxMagic = 0.0f;
            try {
                ISoul soul = (ISoul)player.getCapability(ISoul.INSTANCE).resolve().orElseThrow();
                magic = soul.getMagic();
                maxMagic = soul.getMaxMagic();
            }
            catch (Exception soul) {
                // empty catch block
            }
            if (maxMagic == 0.0f) {
                return;
            }
            if (!(player.m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof IManaRelatedItem) && !(player.m_21120_(InteractionHand.OFF_HAND).m_41720_() instanceof IManaRelatedItem)) {
                return;
            }
            int length = Mth.m_14167_((float)(114.0f * magic / maxMagic));
            int iconU = 48;
            int iconV = 48;
            mStack.m_85836_();
            mStack.m_85837_(0.0, 0.0, 0.01);
            if (isHoriz) {
                guiGraphics.m_280218_(MANA_BAR_TEXTURE, ox -= 4, oy, 2, length == 0 ? 6 : 38, 6, 20);
                if (xp > 0) {
                    guiGraphics.m_280218_(MANA_BAR_TEXTURE, ox - 23, oy - 2, 0, 64, 24, 24);
                    guiGraphics.m_280218_(MANA_BAR_TEXTURE, ox - 18, oy + 4, iconU, iconV, 12, 12);
                }
                int firstSegment = Math.min(8, length);
                length -= firstSegment;
                guiGraphics.m_280218_(MANA_BAR_TEXTURE, ox += 6, oy, 8, 38, firstSegment, 20);
                ox += firstSegment;
                if (firstSegment < 8) {
                    guiGraphics.m_280218_(MANA_BAR_TEXTURE, ox, oy, 8 + firstSegment, 6, 8 - firstSegment, 20);
                    ox += 8 - firstSegment;
                }
                for (int i = 0; i < 6; ++i) {
                    int segment = Math.min(16, length);
                    length -= segment;
                    guiGraphics.m_280218_(MANA_BAR_TEXTURE, ox, oy, 16, 38, segment, 20);
                    ox += segment;
                    if (segment >= 16) continue;
                    guiGraphics.m_280218_(MANA_BAR_TEXTURE, ox, oy, 16 + segment, 6, 16 - segment, 20);
                    ox += 16 - segment;
                }
                int lastSegment = Math.min(8, length);
                length -= lastSegment;
                guiGraphics.m_280218_(MANA_BAR_TEXTURE, ox, oy, 32, 38, lastSegment, 20);
                ox += lastSegment;
                if (lastSegment < 8) {
                    guiGraphics.m_280218_(MANA_BAR_TEXTURE, ox, oy, 32 + lastSegment, 6, 8 - lastSegment, 20);
                    ox += 8 - lastSegment;
                }
                guiGraphics.m_280218_(MANA_BAR_TEXTURE, ox, oy, 40, Mth.m_14167_((float)(114.0f * magic / maxMagic)) == 114 ? 6 : 38, 7, 20);
                if (xp <= 0) {
                    guiGraphics.m_280218_(MANA_BAR_TEXTURE, ox + 5, oy - 2, 32, 64, 24, 24);
                    guiGraphics.m_280218_(MANA_BAR_TEXTURE, ox + 12, oy + 4, iconU, iconV, 12, 12);
                }
            } else {
                oy += 16;
                guiGraphics.m_280218_(MANA_BAR_TEXTURE, ox, oy += 114, length == 0 ? 54 : 86, 40, 20, 6);
                if (yp < 0) {
                    guiGraphics.m_280218_(MANA_BAR_TEXTURE, ox - 2, oy + 5, 32, 96, 24, 24);
                    guiGraphics.m_280218_(MANA_BAR_TEXTURE, ox + 4, oy + 12, iconU, iconV, 12, 12);
                }
                int firstSegment = Math.min(8, length);
                length -= firstSegment;
                guiGraphics.m_280218_(MANA_BAR_TEXTURE, ox, oy -= firstSegment, 86, 32, 20, firstSegment);
                if (firstSegment < 8) {
                    guiGraphics.m_280218_(MANA_BAR_TEXTURE, ox, oy -= 8 - firstSegment, 54, 32 + firstSegment, 20, 8 - firstSegment);
                }
                for (int i = 0; i < 6; ++i) {
                    int segment = Math.min(16, length);
                    length -= segment;
                    guiGraphics.m_280218_(MANA_BAR_TEXTURE, ox, oy -= segment, 86, 16, 20, segment);
                    if (segment >= 16) continue;
                    guiGraphics.m_280218_(MANA_BAR_TEXTURE, ox, oy -= 16 - segment, 54, 16 + segment, 20, 16 - segment);
                }
                int lastSegment = Math.min(8, length);
                length -= lastSegment;
                guiGraphics.m_280218_(MANA_BAR_TEXTURE, ox, oy -= lastSegment, 86, 8, 20, lastSegment);
                if (lastSegment < 8) {
                    guiGraphics.m_280218_(MANA_BAR_TEXTURE, ox, oy -= 8 - lastSegment, 54, 8 + lastSegment, 20, 8 - lastSegment);
                }
                guiGraphics.m_280218_(MANA_BAR_TEXTURE, ox, oy -= 6, Mth.m_14167_((float)(114.0f * magic / maxMagic)) == 114 ? 54 : 86, 2, 20, 6);
                if (yp >= 0) {
                    guiGraphics.m_280218_(MANA_BAR_TEXTURE, ox - 2, oy - 23, 0, 96, 24, 24);
                    guiGraphics.m_280218_(MANA_BAR_TEXTURE, ox + 4, oy - 18, iconU, iconV, 12, 12);
                }
            }
            mStack.m_85849_();
        }
    }
}

