/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.statemachine.starbuncle;

import com.hollingsworth.arsnouveau.common.block.SourceBerryBush;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.debug.DebugEvent;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.StarbyTransportBehavior;
import com.hollingsworth.arsnouveau.common.entity.statemachine.starbuncle.DecideStarbyActionState;
import com.hollingsworth.arsnouveau.common.entity.statemachine.starbuncle.StarbyState;
import com.hollingsworth.arsnouveau.common.entity.statemachine.starbuncle.TravelToPosState;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import java.util.ArrayList;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class HarvestBerryState
extends TravelToPosState {
    public HarvestBerryState(Starbuncle starbuncle, StarbyTransportBehavior behavior, BlockPos target) {
        super(starbuncle, behavior, target, new DecideStarbyActionState(starbuncle, behavior));
    }

    @Override
    public StarbyState onDestinationReached() {
        if (this.level.m_8055_(this.targetPos).m_60734_() instanceof SourceBerryBush) {
            int i = (Integer)this.level.m_8055_(this.targetPos).m_61143_((Property)SourceBerryBush.AGE);
            boolean flag = i == 3;
            this.starbuncle.m_7618_(EntityAnchorArgument.Anchor.EYES, new Vec3((double)this.targetPos.m_123341_(), (double)this.targetPos.m_123342_(), (double)this.targetPos.m_123343_()));
            int j = 1 + this.level.f_46441_.m_188503_(2);
            SourceBerryBush.m_49840_((Level)this.level, (BlockPos)this.targetPos, (ItemStack)new ItemStack(BlockRegistry.SOURCEBERRY_BUSH, j + (flag ? 1 : 0)));
            this.level.m_5594_(null, this.targetPos, SoundEvents.f_12457_, SoundSource.BLOCKS, 1.0f, 0.8f + this.level.f_46441_.m_188501_() * 0.4f);
            this.level.m_7731_(this.targetPos, (BlockState)this.level.m_8055_(this.targetPos).m_61124_((Property)SourceBerryBush.AGE, (Comparable)Integer.valueOf(1)), 2);
            this.starbuncle.addGoalDebug(this, new DebugEvent("PickedBerry", "Popped berries at " + this.targetPos.m_123341_() + "," + this.targetPos.m_123342_() + "," + this.targetPos.m_123343_()));
            for (ItemEntity itemEntity : this.level.m_45976_(ItemEntity.class, this.starbuncle.m_20191_().m_82400_(2.0))) {
                if (itemEntity.m_32055_().m_41720_() != BlockRegistry.SOURCEBERRY_BUSH.m_5456_()) continue;
                this.starbuncle.m_7581_(itemEntity);
                break;
            }
            this.starbuncle.getNavigation().m_26573_();
        }
        return super.onDestinationReached();
    }

    @Override
    public boolean isDestinationStillValid(BlockPos pos) {
        return !this.behavior.isPickupDisabled() && this.starbuncle.getHeldStack().m_41619_() && this.level.m_8055_(pos).m_60734_() instanceof SourceBerryBush && (Integer)this.level.m_8055_(pos).m_61143_((Property)SourceBerryBush.AGE) > 1;
    }

    public static BlockPos getNearbyManaBerry(Level world, Starbuncle entity) {
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        for (BlockPos blockpos : BlockPos.m_121925_((BlockPos)entity.m_20183_(), (int)10, (int)3, (int)10)) {
            Block state = world.m_8055_(blockpos).m_60734_();
            if (!(state instanceof SourceBerryBush) || (Integer)world.m_8055_(blockpos).m_61143_((Property)SourceBerryBush.AGE) <= 1) continue;
            posList.add(blockpos.m_7949_());
        }
        return posList.isEmpty() ? null : (BlockPos)posList.get(world.f_46441_.m_188503_(posList.size()));
    }
}

