/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.statemachine;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.common.entity.statemachine.IState;
import com.hollingsworth.arsnouveau.common.entity.statemachine.IStateEvent;
import com.hollingsworth.arsnouveau.common.util.Log;
import javax.annotation.Nonnull;

public class SimpleStateMachine<State extends IState, Event extends IStateEvent> {
    public static final boolean DEBUG = true;
    protected State currentState;

    public SimpleStateMachine(@Nonnull State initialState) {
        this.currentState = initialState;
        this.currentState.onStart();
    }

    protected void changeState(@Nonnull State nextState) {
        if (ArsNouveau.isDebug) {
            Log.getLogger().debug("Changing state from " + this.currentState + " to " + nextState);
        }
        this.currentState.onEnd();
        this.currentState = nextState;
        this.currentState.onStart();
    }

    public void tick() {
        if (this.currentState == null) {
            return;
        }
        Object nextState = this.currentState.tick();
        if (nextState != null) {
            this.changeState(nextState);
        }
    }

    public void onEvent(Event event) {
        Object nextState = this.currentState.onEvent((IStateEvent)event);
        if (nextState != null) {
            this.changeState(nextState);
        }
    }

    public State getCurrentState() {
        return this.currentState;
    }
}

