/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.datagen;

import com.hollingsworth.arsnouveau.api.recipe.ScryRitualRecipe;
import com.hollingsworth.arsnouveau.common.datagen.SimpleDataProvider;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class ScryRitualProvider
extends SimpleDataProvider {
    public List<ScryRitualRecipe> recipes = new ArrayList<ScryRitualRecipe>();

    public ScryRitualProvider(DataGenerator generatorIn) {
        super(generatorIn);
    }

    @Override
    public void collectJsons(CachedOutput pOutput) {
        this.addEntries();
        for (ScryRitualRecipe recipe : this.recipes) {
            Path path = ScryRitualProvider.getRecipePath(this.output, recipe.m_6423_().m_135815_());
            this.saveStable(pOutput, recipe.asRecipe(), path);
        }
    }

    protected void addEntries() {
        String[] defaultOres;
        for (String ore : defaultOres = new String[]{"coal", "copper", "diamond", "emerald", "gold", "iron", "lapis", "netherite_scrap", "quartz", "redstone"}) {
            this.addForgeOreRecipe(ore);
        }
        this.recipes.add(new ScryRitualRecipe(new ResourceLocation("ars_nouveau", "amethyst_gems"), this.forgeItemTag("gems/amethyst"), this.forgeBlockTag("storage_blocks/amethyst")));
        this.recipes.add(new ScryRitualRecipe(new ResourceLocation("ars_nouveau", "amethyst_blocks"), this.forgeItemTag("storage_blocks/amethyst"), this.forgeBlockTag("storage_blocks/amethyst")));
    }

    private void addForgeOreRecipe(String ore) {
        this.recipes.add(new ScryRitualRecipe(new ResourceLocation("ars_nouveau", ore + "_ores"), this.forgeItemTag("ores/" + ore), this.forgeBlockTag("ores/" + ore)));
    }

    private TagKey<Block> forgeBlockTag(String path) {
        return BlockTags.create((ResourceLocation)this.forgeTag(path));
    }

    private TagKey<Item> forgeItemTag(String path) {
        return ItemTags.create((ResourceLocation)this.forgeTag(path));
    }

    private ResourceLocation forgeTag(String path) {
        return new ResourceLocation("forge", path);
    }

    protected static Path getRecipePath(Path path, String id) {
        return path.resolve("data/ars_nouveau/recipes/scry_ritual/" + id + ".json");
    }

    public String m_6055_() {
        return "Scry Ritual Datagen";
    }
}

