/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.renderer.entity;

import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.block.MageBlock;
import com.hollingsworth.arsnouveau.common.entity.AnimBlockSummon;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.object.Color;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.util.RenderUtils;

public class AnimBlockRenderer<BOBBY extends AnimBlockSummon>
extends GeoEntityRenderer<BOBBY> {
    protected static final ResourceLocation TEXTURE = new ResourceLocation("ars_nouveau", "textures/entity/anim_block.png");
    public static final ResourceLocation BASE_MODEL = new ResourceLocation("ars_nouveau", "geo/animated_block.geo.json");
    public static final ResourceLocation ANIMATIONS = new ResourceLocation("ars_nouveau", "animations/animated_block_animations.json");
    private final BlockRenderDispatcher dispatcher;
    protected MultiBufferSource bufferSource;

    public AnimBlockRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, new GeoModel<BOBBY>(){

            public ResourceLocation getModelResource(BOBBY object) {
                return BASE_MODEL;
            }

            public ResourceLocation getTextureResource(BOBBY object) {
                return TEXTURE;
            }

            public ResourceLocation getAnimationResource(BOBBY animatable) {
                return ANIMATIONS;
            }

            public void setCustomAnimations(BOBBY animatable, long instanceId, AnimationState<BOBBY> customPredicate) {
                super.setCustomAnimations(animatable, instanceId, customPredicate);
                CoreGeoBone head = this.getAnimationProcessor().getBone("block");
                head.setHidden(!(((AnimBlockSummon)animatable).getBlockState().m_60734_() instanceof MageBlock));
            }
        });
        this.dispatcher = renderManager.m_234597_();
    }

    public void render(BOBBY animatable, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.m_85836_();
        poseStack.m_85841_(0.8f, 0.8f, 0.8f);
        super.m_7392_(animatable, entityYaw, partialTick, poseStack, bufferSource, packedLight);
        poseStack.m_85849_();
    }

    public void preRender(PoseStack poseStack, BOBBY animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.bufferSource = bufferSource;
        super.preRender(poseStack, animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void renderRecursively(PoseStack poseStack, BOBBY animatable, GeoBone bone, RenderType ty, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (bone.getName().equals("block")) {
            BOBBY animBlock = animatable;
            if (animBlock == null) {
                return;
            }
            BlockState blockstate = ((AnimBlockSummon)animatable).getBlockState();
            if (!(blockstate.m_60734_() instanceof MageBlock)) {
                try {
                    Level level = animatable.m_9236_();
                    if (blockstate != level.m_8055_(animBlock.m_20183_()) && blockstate.m_60799_() != RenderShape.INVISIBLE) {
                        poseStack.m_85836_();
                        BlockPos blockpos = animBlock.m_20183_().m_7494_();
                        RenderUtils.translateToPivotPoint((PoseStack)poseStack, (CoreGeoBone)bone);
                        poseStack.m_85837_(-0.5, -0.5, -0.5);
                        BakedModel model = this.dispatcher.m_110910_(blockstate);
                        for (RenderType renderType : model.getRenderTypes(blockstate, RandomSource.m_216335_((long)blockstate.m_60726_(animBlock.m_20183_())), ModelData.EMPTY)) {
                            this.dispatcher.m_110937_().tesselateBlock((BlockAndTintGetter)level, model, blockstate, blockpos, poseStack, this.bufferSource.m_6299_(renderType), false, RandomSource.m_216327_(), blockstate.m_60726_(animBlock.m_20097_()), OverlayTexture.f_118083_, ModelData.EMPTY, renderType);
                        }
                        poseStack.m_85849_();
                        buffer = this.bufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)TEXTURE));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        super.renderRecursively(poseStack, animatable, bone, ty, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public Color getRenderColor(BOBBY animatable, float partialTick, int packedLight) {
        if (animatable != null) {
            ParticleColor color = ParticleColor.fromInt(((AnimBlockSummon)animatable).getColor());
            return Color.ofRGBA((float)color.getRed(), (float)color.getGreen(), (float)color.getBlue(), (float)0.75f);
        }
        return super.getRenderColor(animatable, partialTick, packedLight);
    }
}

