/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.gui.book;

import com.hollingsworth.arsnouveau.client.gui.BookSlider;
import com.hollingsworth.arsnouveau.client.gui.book.BaseBook;
import com.hollingsworth.arsnouveau.client.gui.buttons.ANButton;
import com.hollingsworth.arsnouveau.client.gui.buttons.GuiImageButton;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.RainbowParticleColor;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketUpdateSpellColorAll;
import com.hollingsworth.arsnouveau.common.network.PacketUpdateSpellColors;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;

public class GuiColorScreen
extends BaseBook {
    double startRed;
    double startGreen;
    double startBlue;
    public int slot;
    public int page = 0;
    public BookSlider redW;
    public BookSlider greenW;
    public BookSlider blueW;
    public InteractionHand stackHand;
    public List<ANButton> buttons = new ArrayList<ANButton>();

    protected GuiColorScreen(double startRed, double startGreen, double startBlue, int forSpellSlot, InteractionHand stackHand) {
        this.startRed = startRed;
        this.startGreen = startGreen;
        this.startBlue = startBlue;
        this.slot = forSpellSlot;
        this.stackHand = stackHand;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.redW = this.buildSlider(this.bookLeft + 28, this.bookTop + 49, (Component)Component.m_237115_((String)"ars_nouveau.color_gui.red_slider"), (Component)Component.m_237119_(), this.startRed);
        this.greenW = this.buildSlider(this.bookLeft + 28, this.bookTop + 89, (Component)Component.m_237115_((String)"ars_nouveau.color_gui.green_slider"), (Component)Component.m_237119_(), this.startGreen);
        this.blueW = this.buildSlider(this.bookLeft + 28, this.bookTop + 129, (Component)Component.m_237115_((String)"ars_nouveau.color_gui.blue_slider"), (Component)Component.m_237119_(), this.startBlue);
        this.m_142416_((GuiEventListener)this.redW);
        this.m_142416_((GuiEventListener)this.greenW);
        this.m_142416_((GuiEventListener)this.blueW);
        this.m_142416_((GuiEventListener)new GuiImageButton(this.bookLeft + 25, this.bookBottom - 36, 0, 0, 37, 12, 37, 12, "textures/gui/save_icon.png", this::onSaveClick));
        this.m_142416_((GuiEventListener)new GuiImageButton(this.bookLeft + 75, this.bookBottom - 36, 0, 0, 37, 12, 37, 12, "textures/gui/save_icon.png", this::onSaveAllClick));
        this.layoutPageOne();
        PageButton next = (PageButton)this.m_142416_((GuiEventListener)new PageButton(this.bookRight - 20, this.bookBottom - 10, true, this::onPageIncrease, true));
        next.f_93624_ = true;
        next.f_93623_ = true;
    }

    private void layoutPageOne() {
        this.addPresetColorButton(131, 44, ParticleColor.DEFAULT, "textures/gui/color_icons/purple_color_icon.png");
        this.addPresetColorButton(131, 68, ParticleColor.YELLOW, "textures/gui/color_icons/yellow_color_icon.png");
        this.addPresetColorButton(131, 92, ParticleColor.BLUE, "textures/gui/color_icons/blue_color_icon.png");
        this.addPresetColorButton(131, 116, ParticleColor.RED, "textures/gui/color_icons/red_color_icon.png");
        this.addPresetColorButton(131, 140, ParticleColor.GREEN, "textures/gui/color_icons/green_color_icon.png");
        this.addColorButton(73, 44, "textures/gui/color_icons/rainbow_color_icon.png", () -> Networking.INSTANCE.sendToServer((Object)new PacketUpdateSpellColors(this.slot, new RainbowParticleColor(0, 0, 0), this.stackHand == InteractionHand.MAIN_HAND)));
        this.addPresetColorButton(73, 68, ParticleColor.ORANGE, "textures/gui/color_icons/orange_color_icon.png");
        this.addPresetColorButton(73, 92, ParticleColor.CYAN, "textures/gui/color_icons/cyan_color_icon.png");
        this.addPresetColorButton(73, 116, ParticleColor.PINK, "textures/gui/color_icons/pink_color_icon.png");
        this.addPresetColorButton(73, 140, ParticleColor.LIME, "textures/gui/color_icons/lime_color_icon.png");
    }

    private void layoutPageTwo() {
        this.addPresetColorButton(131, 44, ParticleColor.WHITE, "textures/gui/color_icons/white_color_icon.png");
        this.addPresetColorButton(131, 68, ParticleColor.MAGENTA, "textures/gui/color_icons/magenta_color_icon.png");
        this.addPresetColorButton(131, 92, ParticleColor.LIGHT_BLUE, "textures/gui/color_icons/light_blue_color_icon.png");
        this.addPresetColorButton(73, 44, ParticleColor.BLACK, "textures/gui/color_icons/black_color_icon.png");
        this.addPresetColorButton(73, 68, ParticleColor.BROWN, "textures/gui/color_icons/brown_color_icon.png");
        this.addPresetColorButton(73, 92, ParticleColor.GRAY, "textures/gui/color_icons/gray_color_icon.png");
    }

    private void layoutPageThree() {
        this.addColorButton(131, 44, "textures/gui/color_icons/purple_color_icon.png", () -> this.setFromPreset(255, 25, 180));
        this.addPresetColorButton(131, 68, ParticleColor.BROWN, "textures/gui/color_icons/default_color_icon.png");
        this.addColorButton(131, 92, "textures/gui/color_icons/blue_color_icon.png", () -> this.setFromPreset(30, 25, 255));
        this.addColorButton(131, 116, "textures/gui/color_icons/red_color_icon.png", () -> this.setFromPreset(255, 25, 25));
        this.addColorButton(131, 140, "textures/gui/color_icons/green_color_icon.png", () -> this.setFromPreset(25, 255, 25));
        this.addColorButton(73, 44, "textures/gui/color_icons/yellow_color_icon.png", () -> this.setFromPreset(255, 255, 25));
        this.addPresetColorButton(73, 68, ParticleColor.WHITE, "textures/gui/color_icons/white_color_icon.png");
        this.addColorButton(73, 92, "textures/gui/color_icons/orange_color_icon.png", () -> this.setFromPreset(255, 90, 1));
        this.addPresetColorButton(73, 116, ParticleColor.CYAN, "textures/gui/color_icons/cyan_color_icon.png");
        this.m_142416_((GuiEventListener)new GuiImageButton(this.bookRight - 73, this.bookTop + 140, 0, 0, 48, 11, 48, 11, "textures/gui/color_icons/white_color_icon.png", _2 -> Networking.INSTANCE.sendToServer((Object)new PacketUpdateSpellColors(this.slot, new RainbowParticleColor(0, 0, 0), this.stackHand == InteractionHand.MAIN_HAND))));
    }

    protected void addColorButton(int x, int y, String texturePath, Runnable onClick) {
        GuiImageButton pWidget = new GuiImageButton(this.bookRight - x, this.bookTop + y, 0, 0, 48, 11, 48, 11, texturePath, _2 -> onClick.run());
        this.m_142416_((GuiEventListener)pWidget);
        this.buttons.add(pWidget);
    }

    protected void addPresetColorButton(int x, int y, ParticleColor color, String texturePath) {
        this.addColorButton(x, y, texturePath, () -> this.setFromPreset(color));
    }

    public void setFromPreset(int r, int g, int b) {
        this.redW.m_93611_(r);
        this.greenW.m_93611_(g);
        this.blueW.m_93611_(b);
    }

    public void setFromPreset(ParticleColor preset) {
        this.redW.m_93611_(Mth.m_14008_((double)((double)preset.getRed() * 255.0), (double)1.0, (double)255.0));
        this.greenW.m_93611_(Mth.m_14008_((double)((double)preset.getGreen() * 255.0), (double)1.0, (double)255.0));
        this.blueW.m_93611_(Mth.m_14008_((double)((double)preset.getBlue() * 255.0), (double)1.0, (double)255.0));
    }

    public void onSaveClick(Button button) {
        Networking.INSTANCE.sendToServer((Object)new PacketUpdateSpellColors(this.slot, new ParticleColor(this.redW.getValue(), this.greenW.getValue(), this.blueW.getValue()), this.stackHand == InteractionHand.MAIN_HAND));
    }

    public void onSaveAllClick(Button button) {
        Networking.INSTANCE.sendToServer((Object)new PacketUpdateSpellColorAll(this.slot, new ParticleColor(this.redW.getValue(), this.greenW.getValue(), this.blueW.getValue()), this.stackHand == InteractionHand.MAIN_HAND));
    }

    @Override
    public void drawBackgroundElements(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawBackgroundElements(graphics, mouseX, mouseY, partialTicks);
        graphics.m_280163_(new ResourceLocation("ars_nouveau", "textures/gui/slider_gilding.png"), 22, 47, 0.0f, 0.0f, 112, 104, 112, 104);
        int color = -8355712;
        graphics.m_280056_(this.f_96547_, Component.m_237115_((String)"ars_nouveau.color_gui.title").getString(), 51, 24, color, false);
        graphics.m_280056_(this.f_96547_, Component.m_237115_((String)"ars_nouveau.color_gui.presets").getString(), 159, 24, color, false);
        if (this.page == 0) {
            graphics.m_280056_(this.f_96547_, Component.m_237115_((String)"ars_nouveau.color_gui.default").getString(), 170, 46, color, false);
            graphics.m_280056_(this.f_96547_, Component.m_237115_((String)"ars_nouveau.color_gui.yellow").getString(), 170, 70, color, false);
            graphics.m_280056_(this.f_96547_, Component.m_237115_((String)"ars_nouveau.color_gui.blue").getString(), 170, 94, color, false);
            graphics.m_280056_(this.f_96547_, Component.m_237115_((String)"ars_nouveau.color_gui.red").getString(), 170, 118, color, false);
            graphics.m_280056_(this.f_96547_, Component.m_237115_((String)"ars_nouveau.color_gui.green").getString(), 170, 142, color, false);
            graphics.m_280056_(this.f_96547_, Component.m_237115_((String)"ars_nouveau.color_gui.rainbow").getString(), 228, 46, color, false);
            graphics.m_280056_(this.f_96547_, Component.m_237115_((String)"ars_nouveau.color_gui.orange").getString(), 228, 70, color, false);
            graphics.m_280056_(this.f_96547_, Component.m_237115_((String)"ars_nouveau.color_gui.cyan").getString(), 228, 94, color, false);
            graphics.m_280056_(this.f_96547_, Component.m_237115_((String)"ars_nouveau.color_gui.pink").getString(), 228, 118, color, false);
            graphics.m_280056_(this.f_96547_, Component.m_237115_((String)"ars_nouveau.color_gui.lime").getString(), 228, 142, color, false);
        } else {
            graphics.m_280056_(this.f_96547_, Component.m_237115_((String)"ars_nouveau.color_gui.white").getString(), 170, 46, color, false);
            graphics.m_280056_(this.f_96547_, Component.m_237115_((String)"ars_nouveau.color_gui.magenta").getString(), 170, 70, color, false);
            graphics.m_280056_(this.f_96547_, Component.m_237115_((String)"ars_nouveau.color_gui.light_blue").getString(), 170, 94, color, false);
            graphics.m_280056_(this.f_96547_, Component.m_237115_((String)"ars_nouveau.color_gui.black").getString(), 228, 46, color, false);
            graphics.m_280056_(this.f_96547_, Component.m_237115_((String)"ars_nouveau.color_gui.brown").getString(), 228, 70, color, false);
            graphics.m_280056_(this.f_96547_, Component.m_237115_((String)"ars_nouveau.color_gui.gray").getString(), 228, 94, color, false);
        }
        graphics.m_280056_(this.f_96547_, Component.m_237115_((String)"ars_nouveau.color_gui.save").getString(), 37, 160, color, false);
        graphics.m_280056_(this.f_96547_, Component.m_237115_((String)"ars_nouveau.color_gui.save_all").getString(), 87, 160, color, false);
    }

    public int getNumPages() {
        return 2;
    }

    public void onPageIncrease(Button b) {
        this.page = (this.page + 1) % this.getNumPages();
        this.clearButtons(this.buttons);
        switch (this.page) {
            default: {
                this.layoutPageOne();
                break;
            }
            case 1: {
                this.layoutPageTwo();
                break;
            }
            case 2: {
                this.layoutPageThree();
            }
        }
    }
}

