/*
 * Decompiled with CFR 0.152.
 */
package mod.motivationaldragon.potionblender.blockentities;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import mod.motivationaldragon.potionblender.Constants;
import mod.motivationaldragon.potionblender.advancements.PotionBlenderCriterionTrigger;
import mod.motivationaldragon.potionblender.block.BrewingCauldron;
import mod.motivationaldragon.potionblender.config.ConfigController;
import mod.motivationaldragon.potionblender.config.PotionBlenderConfig;
import mod.motivationaldragon.potionblender.platform.Service;
import mod.motivationaldragon.potionblender.recipes.BrewingCauldronRecipe;
import mod.motivationaldragon.potionblender.utils.ModUtils;
import mod.motivationaldragon.potionblender.utils.PotionEffectMerger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BrewingCauldronBlockEntity
extends BlockEntity {
    private static final String POTION_MIXER_KEY = "potionblender.ConfigController";
    private static final int ITEM_DROP_OFFSET = 1;
    private static final PotionBlenderConfig config = ConfigController.getConfig();
    private boolean isBrewing = false;
    private boolean canBrew = false;
    private int brewingProgress = 0;
    private NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)ConfigController.getConfig().getCauldronInventorySize(), (Object)ItemStack.f_41583_);
    private int numberOfItems = 0;
    private final RecipeManager.CachedCheck<Container, BrewingCauldronRecipe> quickCheck = RecipeManager.m_220267_((RecipeType)BrewingCauldronRecipe.Type.INSTANCE);
    private int waterColor = 3694022;

    protected BrewingCauldronBlockEntity(BlockPos pos, BlockState state) {
        super(Service.PLATFORM.getPlatformBrewingCauldron(), pos, state);
    }

    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    public int size() {
        return this.inventory.size();
    }

    private void updateListeners() {
        this.m_6596_();
        this.syncInventoryWithClient();
        assert (this.m_58904_() != null);
        this.m_58904_().m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 1);
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    protected abstract void syncInventoryWithClient();

    public void onUseDelegate(BlockState state, Level level, BlockPos pos, Player player) {
        if (this.numberOfItems >= 1) {
            this.stopBrewing();
            this.dropInventoryContent();
        }
    }

    private void stopBrewing() {
        this.canBrew = false;
        this.isBrewing = false;
        this.resetProgress();
        this.m_58900_().m_61124_((Property)BrewingCauldron.IS_BREWING, (Comparable)Boolean.valueOf(false));
        this.m_6596_();
    }

    public void onEntityLandDelegate(Entity entity) {
        assert (this.f_58857_ != null);
        if (this.f_58857_.m_5776_() || this.isBrewing) {
            return;
        }
        if (entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            ItemStack itemStack = itemEntity.m_32055_();
            if (ModUtils.isACombinedPotion(itemStack) && itemEntity.m_19749_() != null) {
                this.explode(entity);
                entity.m_142687_(Entity.RemovalReason.DISCARDED);
                return;
            }
            if (itemStack.m_150930_(Items.f_42589_) && this.numberOfItems < this.inventory.size() && PotionEffectMerger.wouldIgnoreInstantPotion(itemStack, this.getInventoryStatusEffectsInstances())) {
                return;
            }
            if (this.numberOfItems >= this.inventory.size()) {
                return;
            }
            this.addItemToCauldron(itemEntity);
            if (((Boolean)this.m_58900_().m_61143_((Property)BrewingCauldron.LIT)).booleanValue() && this.getRecipe().isPresent()) {
                entity.m_142687_(Entity.RemovalReason.DISCARDED);
                this.canBrew = true;
                this.waterColor = this.computeWaterColor();
                this.m_58904_().m_46597_(this.m_58899_(), (BlockState)this.m_58904_().m_8055_(this.m_58899_()).m_61124_((Property)BrewingCauldron.IS_BREWING, (Comparable)Boolean.valueOf(true)));
                this.m_6596_();
                this.f_58857_.m_247517_(null, this.m_58899_(), SoundEvents.f_11874_, SoundSource.BLOCKS);
            }
        }
    }

    private Optional<BrewingCauldronRecipe> getRecipe() {
        if (this.numberOfItems <= 0) {
            return Optional.empty();
        }
        SimpleContainer container = new SimpleContainer((ItemStack[])this.inventory.stream().filter(itemStack -> !itemStack.m_150930_(Items.f_41852_)).toArray(ItemStack[]::new));
        return this.quickCheck.m_213657_((Container)container, this.f_58857_);
    }

    private void craftCombinedPotion(Level level, @NotNull BlockPos pos, BrewingCauldronRecipe recipe) {
        if (level.m_5776_()) {
            return;
        }
        Item potionType = recipe.m_8043_(level.m_9598_()).m_41720_();
        ItemStack potionToCraft = new ItemStack((ItemLike)potionType);
        if (potionToCraft.m_150930_(Items.f_42589_)) {
            potionToCraft.m_41784_().m_128379_("potionblender_IsCombinedPotion", true);
        } else if (potionToCraft.m_150930_(Items.f_42736_)) {
            potionToCraft.m_41784_().m_128379_("potionblender_IsCombinedSplashPotion", true);
        } else if (potionToCraft.m_150930_(Items.f_42739_)) {
            potionToCraft.m_41784_().m_128379_("potionblender_IsCombinedLingeringPotion", true);
        } else {
            Constants.LOG.error(String.format("Cannot merge potion to an item that is not a potion. Valid potion are Potions, Splash Potions, Lingering Potion. Did you try merge potion into an item that is not a potion?The item is: %s", potionToCraft.m_41720_()));
            Containers.m_19010_((Level)level, (BlockPos)pos, this.inventory);
            this.emptyCauldron();
            return;
        }
        List<MobEffectInstance> finalPotionStatusEffects = PotionEffectMerger.mergeCombinableEffects(this.getInventoryStatusEffectsInstances(), recipe.getDecayRate());
        if (ModUtils.isCombinedLingeringPotion(potionToCraft)) {
            finalPotionStatusEffects = PotionEffectMerger.mergeLingeringPotionEffects(finalPotionStatusEffects);
        }
        ItemStack potionItemStack = PotionUtils.m_43552_((ItemStack)potionToCraft, finalPotionStatusEffects);
        int color = PotionUtils.m_43564_(finalPotionStatusEffects);
        potionItemStack.m_41784_().m_128405_("CustomPotionColor", color);
        BrewingCauldronBlockEntity.outputItem(level, pos, potionItemStack);
        int nbOfPotions = this.inventory.stream().filter(itemStack -> itemStack.m_41720_() instanceof PotionItem).mapToInt(ItemStack::m_41613_).sum();
        Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)((double)pos.m_123342_() + 1.0), (double)pos.m_123343_(), (ItemStack)new ItemStack((ItemLike)Items.f_42590_, --nbOfPotions));
        this.emptyCauldron();
    }

    private static void outputItem(Level level, @NotNull BlockPos pos, ItemStack potionItemStack) {
        ItemEntity outputItemEntity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, potionItemStack);
        outputItemEntity.m_20242_(true);
        outputItemEntity.m_20256_(Vec3.f_82478_);
        outputItemEntity.m_32052_(null);
        level.m_7967_((Entity)outputItemEntity);
        level.m_5594_(null, pos, SoundEvents.f_11772_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, BrewingCauldronBlockEntity brewingCauldron) {
        if (level.m_5776_()) {
            return;
        }
        if (!brewingCauldron.canBrew) {
            brewingCauldron.resetProgress();
            return;
        }
        brewingCauldron.isBrewing = true;
        ++brewingCauldron.brewingProgress;
        Optional<BrewingCauldronRecipe> optionalBrewingCauldronRecipe = brewingCauldron.getRecipe();
        if (optionalBrewingCauldronRecipe.isEmpty()) {
            brewingCauldron.stopBrewing();
            return;
        }
        BrewingCauldronRecipe recipe = optionalBrewingCauldronRecipe.get();
        if (brewingCauldron.brewingProgress >= recipe.getBrewingTime()) {
            if (recipe.usePotionMeringRules()) {
                brewingCauldron.craftCombinedPotion(level, pos, recipe);
            } else {
                BrewingCauldronBlockEntity.outputItem(level, pos, recipe.m_8043_(level.m_9598_()));
                brewingCauldron.emptyCauldron();
                brewingCauldron.updateListeners();
            }
            brewingCauldron.stopBrewing();
        }
        BrewingCauldronBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
    }

    private void resetProgress() {
        this.brewingProgress = 0;
    }

    private void dropInventoryContent() {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11752_, SoundSource.BLOCKS, 1.0f, 1.0f);
        Containers.m_19010_((Level)this.f_58857_, (BlockPos)this.m_58899_().m_7918_(0, 1, 0), this.getInventory());
        this.emptyCauldron();
    }

    private void emptyCauldron() {
        this.inventory.clear();
        this.numberOfItems = 0;
        BlockState blockState = (BlockState)((BlockState)this.f_58857_.m_8055_(this.m_58899_()).m_61124_((Property)BrewingCauldron.HAS_FLUID, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BrewingCauldron.IS_BREWING, (Comparable)Boolean.valueOf(false));
        this.f_58857_.m_46597_(this.m_58899_(), blockState);
        this.updateListeners();
    }

    private void explode(Entity entity) {
        assert (this.f_58857_ != null);
        assert (!this.f_58857_.m_5776_());
        BlockPos pos = this.m_58899_();
        List nearbyPlayers = this.m_58904_().m_45976_(ServerPlayer.class, new AABB(pos).m_82400_(5.0));
        for (ServerPlayer player : nearbyPlayers) {
            PotionBlenderCriterionTrigger.INSTANCE.trigger(player);
        }
        this.f_58857_.m_254849_(entity, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 1.5f, Level.ExplosionInteraction.BLOCK);
    }

    private void addItemToCauldron(@NotNull ItemEntity itemEntity) {
        assert (this.f_58857_ != null);
        if (this.f_58857_.m_5776_()) {
            return;
        }
        this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11707_, SoundSource.BLOCKS, 2.0f * this.f_58857_.f_46441_.m_188501_(), 1.0f);
        this.addItem(itemEntity.m_32055_());
        this.waterColor = this.computeWaterColor();
        BlockState mixerCauldronBlockState = (BlockState)this.f_58857_.m_8055_(this.m_58899_()).m_61124_((Property)BrewingCauldron.HAS_FLUID, (Comparable)Boolean.valueOf(true));
        this.f_58857_.m_46597_(this.m_58899_(), mixerCauldronBlockState);
        itemEntity.m_142687_(Entity.RemovalReason.DISCARDED);
        this.updateListeners();
    }

    private void addItem(@NotNull ItemStack itemStack) {
        assert (this.f_58857_ != null);
        if (this.numberOfItems > this.inventory.size()) {
            this.countPotion(this.inventory);
        }
        if (this.numberOfItems >= this.inventory.size()) {
            return;
        }
        this.inventory.set(this.numberOfItems, (Object)itemStack);
        ++this.numberOfItems;
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        this.inventory = NonNullList.m_122780_((int)this.size(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
        this.numberOfItems = nbt.m_128451_("potionblender.ConfigController_inv_size");
        this.isBrewing = nbt.m_128471_("potionblender.ConfigController_isBrewing");
        this.canBrew = nbt.m_128471_("potionblender.ConfigController_canBrew");
        this.waterColor = nbt.m_128451_("potionblender.ConfigController_waterColor");
        super.m_142466_(nbt);
    }

    protected void m_183515_(@NotNull CompoundTag nbt) {
        ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
        nbt.m_128405_("potionblender.ConfigController_inv_size", this.numberOfItems);
        nbt.m_128379_("potionblender.ConfigController_isBrewing", this.isBrewing);
        nbt.m_128379_("potionblender.ConfigController_canBrew", this.canBrew);
        nbt.m_128405_("potionblender.ConfigController_waterColor", this.computeWaterColor());
        super.m_183515_(nbt);
    }

    public int getWaterColor() {
        return this.waterColor;
    }

    private int computeWaterColor() {
        Optional<BrewingCauldronRecipe> recipe = this.getRecipe();
        if (recipe.isPresent() && !recipe.get().usePotionMeringRules()) {
            return recipe.get().getColor();
        }
        return PotionUtils.m_43564_(this.getInventoryStatusEffectsInstances());
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @NotNull
    protected List<MobEffectInstance> getInventoryStatusEffectsInstances() {
        ArrayList<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();
        if (this.numberOfItems > this.inventory.size()) {
            this.numberOfItems = this.size() - 1;
        }
        for (int i = 0; i < this.numberOfItems; ++i) {
            ItemStack itemStack = (ItemStack)this.inventory.get(i);
            if (!(itemStack.m_41720_() instanceof PotionItem)) continue;
            effects.addAll(PotionUtils.m_43547_((ItemStack)itemStack));
        }
        return effects;
    }

    public void setInventory(NonNullList<ItemStack> newInventory) {
        this.numberOfItems = 0;
        this.inventory = newInventory;
        this.countPotion(newInventory);
    }

    private void countPotion(NonNullList<ItemStack> newInventory) {
        for (ItemStack stack : newInventory) {
            if (stack.m_150930_(Items.f_41852_)) continue;
            ++this.numberOfItems;
        }
    }

    public void markUpdated() {
        this.m_6596_();
        Objects.requireNonNull(this.m_58904_()).m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }

    public int getNumberOfItems() {
        return this.numberOfItems;
    }
}

