/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.data.generator;

import com.blakebr0.mysticalagriculture.api.crop.Crop;
import com.blakebr0.mysticalagriculture.data.recipe.CraftingRecipeBuilder;
import com.blakebr0.mysticalagriculture.data.recipe.InfusionRecipeBuilder;
import com.blakebr0.mysticalagriculture.data.recipe.ReprocessorRecipeBuilder;
import com.blakebr0.mysticalagriculture.lib.ModCrops;
import com.blakebr0.mysticalagriculture.registry.CropRegistry;
import java.util.function.Consumer;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.resources.ResourceLocation;

public class RecipeJsonGenerator
extends RecipeProvider {
    public RecipeJsonGenerator(PackOutput output) {
        super(output);
    }

    protected void m_245200_(Consumer<FinishedRecipe> consumer) {
        for (Crop crop : CropRegistry.getInstance().getCrops()) {
            if (crop != ModCrops.INFERIUM) {
                String craftingId = "seed/crafting/" + crop.getName();
                CraftingRecipeBuilder.newSeedRecipe(crop).build(consumer, new ResourceLocation(crop.getModId(), craftingId));
                String infusionId = "seed/infusion/" + crop.getName();
                InfusionRecipeBuilder.newSeedRecipe(crop).build(consumer, new ResourceLocation(crop.getModId(), infusionId));
            }
            String reprocessorId = "seed/reprocessor/" + crop.getName();
            ReprocessorRecipeBuilder.newSeedReprocessingRecipe(crop).build(consumer, new ResourceLocation(crop.getModId(), reprocessorId));
        }
    }
}

