/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.api.soul;

import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.registries.ForgeRegistries;

public class MobSoulType {
    private final ResourceLocation id;
    private final Set<ResourceLocation> entityIds;
    private double soulRequirement;
    private int color;
    private String entityDisplayNameKey = null;
    private Component entityDisplayName = null;
    private boolean enabled;

    public MobSoulType(ResourceLocation id, ResourceLocation entityId, double soulRequirement, int color) {
        this.id = id;
        this.entityIds = Sets.newHashSet((Object[])new ResourceLocation[]{entityId});
        this.soulRequirement = soulRequirement;
        this.color = color;
        this.enabled = true;
    }

    public MobSoulType(ResourceLocation id, ResourceLocation entityId, String entityDisplayNameKey, double soulRequirement, int color) {
        this.id = id;
        this.entityIds = Sets.newHashSet((Object[])new ResourceLocation[]{entityId});
        this.soulRequirement = soulRequirement;
        this.entityDisplayNameKey = entityDisplayNameKey;
        this.color = color;
        this.enabled = true;
    }

    public MobSoulType(ResourceLocation id, Set<ResourceLocation> entityIds, String entityDisplayNameKey, double soulRequirement, int color) {
        this.id = id;
        this.entityIds = entityIds;
        this.soulRequirement = soulRequirement;
        this.entityDisplayNameKey = entityDisplayNameKey;
        this.color = color;
        this.enabled = true;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public String getName() {
        return this.getId().m_135815_();
    }

    public String getModId() {
        return this.getId().m_135827_();
    }

    public Set<ResourceLocation> getEntityIds() {
        return this.entityIds;
    }

    public double getSoulRequirement() {
        return this.soulRequirement;
    }

    public MobSoulType setSoulRequirement(double soulRequirement) {
        this.soulRequirement = soulRequirement;
        return this;
    }

    public int getColor() {
        return this.color;
    }

    public MobSoulType setColor(int color) {
        this.color = color;
        return this;
    }

    public boolean isEntityApplicable(LivingEntity entity) {
        ResourceLocation id = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
        return this.entityIds.contains(id);
    }

    public Component getEntityDisplayName() {
        if (this.entityDisplayName == null) {
            if (this.entityDisplayNameKey != null) {
                this.entityDisplayName = Component.m_237115_((String)String.format("mobSoulType.%s.%s", this.getModId(), this.entityDisplayNameKey));
            } else {
                EntityType entity;
                ResourceLocation entityId = this.entityIds.stream().findFirst().orElse(null);
                if (entityId != null && (entity = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entityId)) != null) {
                    this.entityDisplayName = entity.m_20676_();
                    return this.entityDisplayName;
                }
                this.entityDisplayName = Component.m_237115_((String)"tooltip.mysticalagriculture.invalid_entity");
            }
        }
        return this.entityDisplayName;
    }

    public MobSoulType setEntityDisplayName(Component name) {
        this.entityDisplayName = name;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public MobSoulType setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }
}

