/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.module;

import mods.railcraft.util.container.ContainerMapper;
import mods.railcraft.world.level.block.entity.steamboiler.SolidFueledSteamBoilerBlockEntity;
import mods.railcraft.world.level.block.entity.steamboiler.SteamBoilerBlockEntity;
import mods.railcraft.world.level.material.steam.SolidFuelProvider;
import mods.railcraft.world.module.SteamBoilerModule;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fluids.FluidUtil;

public class SolidFueledSteamBoilerModule
extends SteamBoilerModule<SolidFueledSteamBoilerBlockEntity> {
    private static final int SLOT_BURN = 3;
    private static final int SLOT_FUEL = 4;
    private final ContainerMapper burnContainer;
    private final ContainerMapper stockContainer;
    private final ContainerMapper fuelContainer;
    private boolean needsFuel;
    private int processTicks;
    private int fuelMoveTicks;

    public SolidFueledSteamBoilerModule(SolidFueledSteamBoilerBlockEntity provider) {
        super(provider, 7);
        this.burnContainer = ContainerMapper.make((Container)this.container, 3, 1);
        this.stockContainer = ContainerMapper.make((Container)this.container, 4, 3);
        this.fuelContainer = ContainerMapper.make((Container)this.container, 3, 4);
        this.boiler.setFuelProvider(new SolidFuelProvider((Container)this.container, 3));
    }

    @Override
    public void serverTick() {
        super.serverTick();
        if (((SolidFueledSteamBoilerBlockEntity)this.provider).isMaster() && this.processTicks++ >= 4) {
            this.processTicks = 0;
            this.stockContainer.moveOneItemTo(this.burnContainer);
            this.needsFuel = this.fuelContainer.countItems() < 64;
        }
        ((SolidFueledSteamBoilerBlockEntity)this.provider).getMembership().ifPresent(membership -> {
            SolidFueledSteamBoilerModule masterModule = ((SteamBoilerBlockEntity)membership.master()).getModule(SolidFueledSteamBoilerModule.class).get();
            if (masterModule.needsFuel && this.fuelMoveTicks++ >= 128) {
                this.fuelMoveTicks = 0;
                ((SolidFueledSteamBoilerBlockEntity)this.provider).findAdjacentContainers().moveOneItemTo(masterModule.fuelContainer, SolidFueledSteamBoilerModule::isFuel);
            }
        });
    }

    @Override
    public boolean m_7013_(int slot, ItemStack itemStack) {
        if (!((SolidFueledSteamBoilerBlockEntity)this.provider).isFormed()) {
            return false;
        }
        if (slot >= 3) {
            return SolidFueledSteamBoilerModule.isFuel(itemStack);
        }
        if (slot == 0) {
            return FluidUtil.getFluidContained((ItemStack)itemStack).map(fluid -> fluid.getFluid().m_205067_(FluidTags.f_13131_)).orElse(false);
        }
        return false;
    }

    private static boolean isFuel(ItemStack itemStack) {
        return ForgeHooks.getBurnTime((ItemStack)itemStack, null) > 0;
    }
}

