/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.track;

import java.util.UUID;
import mods.railcraft.api.carts.RollingStock;
import mods.railcraft.api.carts.Train;
import mods.railcraft.api.event.CartLockdownEvent;
import mods.railcraft.api.track.LockingTrack;
import mods.railcraft.api.track.RailShapeUtil;
import mods.railcraft.util.EntitySearcher;
import mods.railcraft.world.entity.vehicle.MinecartUtil;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntity;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.track.TrackBlock;
import mods.railcraft.world.level.block.track.outfitted.LockingMode;
import mods.railcraft.world.level.block.track.outfitted.LockingModeController;
import mods.railcraft.world.level.block.track.outfitted.LockingTrackBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.Nullable;

public class LockingTrackBlockEntity
extends RailcraftBlockEntity
implements LockingTrack {
    public static final int TRAIN_LOCKDOWN_DELAY = 200;
    public static final double START_BOOST = 0.04;
    public static final double BOOST_FACTOR = 0.06;
    private UUID lockId = UUID.randomUUID();
    private LockingModeController lockingModeController;
    @Nullable
    protected AbstractMinecart currentCart;
    @Nullable
    protected AbstractMinecart prevCart;
    @Nullable
    private UUID prevCartId;
    @Nullable
    private UUID currentCartId;
    @Nullable
    protected Train currentTrain;
    protected boolean trainLeaving;
    protected boolean locked;
    private int trainDelay;

    public LockingTrackBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RailcraftBlockEntityTypes.LOCKING_TRACK.get(), blockPos, blockState);
        this.lockingModeController = LockingTrackBlock.getLockingMode(blockState).create(this);
    }

    public void setLockingModeController(LockingModeController lockingModeController) {
        this.lockingModeController = lockingModeController;
    }

    public void onLoad() {
        super.onLoad();
        this.prevCart = MinecartUtil.getCartFromUUID(this.f_58857_, this.prevCartId);
        this.currentCart = MinecartUtil.getCartFromUUID(this.f_58857_, this.currentCartId);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, LockingTrackBlockEntity blockEntity) {
        boolean changed = false;
        if (blockEntity.currentCart != null && !blockEntity.currentCart.m_6084_()) {
            blockEntity.releaseCurrentCart();
            blockEntity.currentCart = null;
            changed = true;
        }
        boolean lastLocked = blockEntity.locked;
        blockEntity.calculateLocked();
        if (lastLocked != blockEntity.locked) {
            changed = true;
        }
        if (blockEntity.locked) {
            blockEntity.lockCurrentCart();
        } else {
            blockEntity.releaseCurrentCart();
        }
        if (blockEntity.currentCart != null) {
            blockEntity.prevCart = blockEntity.currentCart;
        }
        blockEntity.currentCart = null;
        if (changed) {
            blockEntity.m_6596_();
            blockEntity.syncToClient();
        }
    }

    public void m_7651_() {
        super.m_7651_();
        this.releaseCart();
    }

    private void lockCurrentCart() {
        if (this.currentCart != null) {
            RollingStock rollingStock = RollingStock.getOrThrow(this.currentCart);
            rollingStock.checkHighSpeed(this.blockPos());
            Train train = rollingStock.train();
            if (this.currentTrain != train && this.currentTrain != null) {
                this.currentTrain.removeLock(this.lockId);
            }
            this.currentTrain = train;
            if (this.currentTrain != null) {
                this.currentTrain.addLock(this.lockId);
            }
            MinecraftForge.EVENT_BUS.post((Event)new CartLockdownEvent.Lock(this.currentCart, this.m_58899_()));
            this.lockingModeController.locked(this.currentCart);
            this.currentCart.m_20334_(0.0, this.currentCart.m_20184_().m_7098_(), 0.0);
            RailShape railShape = TrackBlock.getRailShapeRaw(this.m_58900_());
            if (RailShapeUtil.isNorthSouth(railShape)) {
                this.currentCart.m_6034_(this.currentCart.m_20185_(), this.currentCart.m_20186_(), (double)this.m_58899_().m_123343_() + 0.5);
            } else {
                this.currentCart.m_6034_((double)this.m_58899_().m_123341_() + 0.5, this.currentCart.m_20186_(), this.currentCart.m_20189_());
            }
        }
    }

    public void minecartPassed(AbstractMinecart cart) {
        this.currentCart = cart;
        this.lockingModeController.passed(this.currentCart);
    }

    private void releaseCurrentCart() {
        if (this.currentTrain != null) {
            this.currentTrain.removeLock(this.lockId);
        }
        if (this.currentCart != null) {
            MinecraftForge.EVENT_BUS.post((Event)new CartLockdownEvent.Release(this.currentCart, this.m_58899_()));
            this.lockingModeController.released(this.currentCart);
        }
    }

    @Override
    public void releaseCart() {
        this.trainLeaving = true;
    }

    @Override
    public boolean isCartLocked(AbstractMinecart cart) {
        return this.locked && this.prevCart == cart;
    }

    private boolean isSameTrainOrCart() {
        LockingMode lockingMode = LockingTrackBlock.getLockingMode(this.m_58900_());
        if (lockingMode.getLockType().isTrain()) {
            if (this.currentCart != null && this.currentCart.m_6084_() && this.prevCart != null && this.prevCart.m_6084_()) {
                RollingStock prevRollingStock;
                RollingStock rollingStock = RollingStock.getOrThrow(this.currentCart);
                this.trainDelay = rollingStock.isSameTrainAs(prevRollingStock = RollingStock.getOrThrow(this.prevCart)) ? 200 : 0;
            } else if (this.trainLeaving && this.prevCart != null && this.prevCart.m_6084_()) {
                RollingStock prevRollingStock = RollingStock.getOrThrow(this.prevCart);
                if (EntitySearcher.findMinecarts().at(this.m_58899_()).stream(this.f_58857_).map(RollingStock::getOrThrow).anyMatch(cart -> cart.isSameTrainAs(prevRollingStock))) {
                    this.trainDelay = 200;
                }
            }
            if (this.trainDelay > 0) {
                --this.trainDelay;
            } else {
                this.prevCart = null;
            }
            return this.trainDelay > 0;
        }
        return this.currentCart != null && lockingMode.getLockType().isCart() && this.currentCart == this.prevCart;
    }

    private void calculateLocked() {
        boolean powered = LockingTrackBlock.isPowered(this.m_58900_());
        boolean sameTrainOrCart = this.isSameTrainOrCart();
        if (this.trainLeaving) {
            boolean bl = this.locked = !sameTrainOrCart && !powered;
            if (this.locked) {
                this.trainLeaving = false;
            }
        } else {
            boolean bl = this.locked = !powered;
            if (!this.locked && sameTrainOrCart) {
                this.trainLeaving = true;
            }
        }
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("lockingModeController", (Tag)this.lockingModeController.serializeNBT());
        tag.m_128379_("locked", this.locked);
        tag.m_128379_("trainLeaving", this.trainLeaving);
        tag.m_128405_("trainDelay", this.trainDelay);
        if (this.prevCart != null) {
            tag.m_128362_("prevCartId", this.prevCart.m_20148_());
        }
        if (this.currentCart != null) {
            tag.m_128362_("currentCartId", this.currentCart.m_20148_());
        }
        tag.m_128362_("lockId", this.lockId);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.lockingModeController = LockingTrackBlock.getLockingMode(this.m_58900_()).create(this);
        this.lockingModeController.deserializeNBT(tag.m_128469_("lockingModeController"));
        this.locked = tag.m_128471_("locked");
        this.trainLeaving = tag.m_128471_("trainLeaving");
        this.trainDelay = tag.m_128451_("trainDelay");
        if (tag.m_128403_("prevCartId")) {
            this.prevCartId = tag.m_128342_("prevCartId");
        }
        if (tag.m_128403_("currentCartId")) {
            this.currentCartId = tag.m_128342_("currentCartId");
        }
        this.lockId = tag.m_128342_("lockId");
    }

    @Override
    public void writeToBuf(FriendlyByteBuf data) {
        super.writeToBuf(data);
        data.writeBoolean(this.locked);
    }

    @Override
    public void readFromBuf(FriendlyByteBuf data) {
        super.readFromBuf(data);
        this.locked = data.readBoolean();
    }
}

