/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.track;

import mods.railcraft.RailcraftConfig;
import mods.railcraft.api.carts.RollingStock;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntity;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.track.outfitted.PoweredOutfittedTrackBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class LauncherTrackBlockEntity
extends RailcraftBlockEntity {
    public static final int MIN_LAUNCH_FORCE = 5;
    private static final float LAUNCH_THRESHOLD = 0.01f;
    private byte launchForce = (byte)5;

    public LauncherTrackBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RailcraftBlockEntityTypes.LAUNCHER_TRACK.get(), blockPos, blockState);
    }

    public void minecartPassed(AbstractMinecart cart) {
        if (PoweredOutfittedTrackBlock.isPowered(this.m_58900_())) {
            Vec3 motion = cart.m_20184_();
            double newMotionX = motion.m_7096_();
            double newMotionZ = motion.m_7094_();
            if (Math.abs(motion.m_7096_()) > (double)0.01f) {
                newMotionX = Math.copySign((double)0.6f, motion.m_7096_());
            }
            if (Math.abs(motion.m_7094_()) > (double)0.01f) {
                newMotionZ = Math.copySign((double)0.6f, motion.m_7094_());
            }
            cart.setMaxSpeedAirLateral(0.6f);
            cart.setMaxSpeedAirVertical(0.5f);
            cart.setDragAir(0.99999);
            RollingStock.getOrThrow(cart).launch();
            cart.m_20334_(newMotionX, (double)this.getLaunchForce() * 0.1, newMotionZ);
            cart.m_6478_(MoverType.SELF, cart.m_20184_());
        }
    }

    public byte getLaunchForce() {
        return this.launchForce;
    }

    public void setLaunchForce(byte launchForce) {
        this.launchForce = (byte)Mth.m_14045_((int)launchForce, (int)5, (int)((Integer)RailcraftConfig.SERVER.maxLauncherTrackForce.get()));
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128344_("launchForce", this.launchForce);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.launchForce = tag.m_128445_("launchForce");
    }

    @Override
    public void writeToBuf(FriendlyByteBuf out) {
        super.writeToBuf(out);
        out.writeByte((int)this.launchForce);
    }

    @Override
    public void readFromBuf(FriendlyByteBuf in) {
        super.readFromBuf(in);
        this.launchForce = in.readByte();
    }
}

