/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.track;

import mods.railcraft.api.track.RailShapeUtil;
import mods.railcraft.world.entity.vehicle.MinecartUtil;
import mods.railcraft.world.level.block.entity.track.LockingTrackBlockEntity;
import mods.railcraft.world.level.block.track.TrackBlock;
import mods.railcraft.world.level.block.track.outfitted.LockingModeController;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.Vec3;

public class BoardingLockingProfile
implements LockingModeController {
    private final LockingTrackBlockEntity lockingTrack;
    private final boolean reversed;

    private BoardingLockingProfile(LockingTrackBlockEntity lockingTrack, boolean reversed) {
        this.lockingTrack = lockingTrack;
        this.reversed = reversed;
    }

    @Override
    public void released(AbstractMinecart cart) {
        RailShape railShape = TrackBlock.getRailShapeRaw(this.lockingTrack.m_58900_());
        cart.m_20256_(this.applyBoost(RailShapeUtil.isNorthSouth(railShape) ? Direction.Axis.Z : Direction.Axis.X, cart.m_20184_()));
    }

    private Vec3 applyBoost(Direction.Axis axis, Vec3 deltaMovement) {
        double boost;
        double speed = MinecartUtil.getCartSpeedUncapped(deltaMovement);
        double d = boost = speed > 0.005 ? Math.abs(deltaMovement.m_82507_(axis)) / speed * 0.06 : 0.04;
        Vec3 newDeltaMovement = this.reversed ? deltaMovement.m_82520_(axis == Direction.Axis.X ? -boost : 0.0, 0.0, axis == Direction.Axis.Z ? boost : 0.0) : deltaMovement.m_82520_(axis == Direction.Axis.X ? boost : 0.0, 0.0, axis == Direction.Axis.Z ? -boost : 0.0);
        return newDeltaMovement;
    }

    public static BoardingLockingProfile normal(LockingTrackBlockEntity lockingTrack) {
        return new BoardingLockingProfile(lockingTrack, false);
    }

    public static BoardingLockingProfile reversed(LockingTrackBlockEntity lockingTrack) {
        return new BoardingLockingProfile(lockingTrack, true);
    }
}

