/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.signal;

import java.util.Objects;
import java.util.UUID;
import mods.railcraft.api.signal.SignalAspect;
import mods.railcraft.api.signal.SimpleSignalController;
import mods.railcraft.api.signal.TokenSignalEntity;
import mods.railcraft.api.signal.TrackLocator;
import mods.railcraft.api.signal.entity.SignalControllerEntity;
import mods.railcraft.util.EntitySearcher;
import mods.railcraft.util.TimerBag;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.signal.AbstractSignalBlockEntity;
import mods.railcraft.world.signal.SimpleTokenRing;
import mods.railcraft.world.signal.TokenRingManager;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class TokenSignalBlockEntity
extends AbstractSignalBlockEntity
implements SignalControllerEntity,
TokenSignalEntity {
    private final SimpleSignalController signalController = new SimpleSignalController(1, this::syncToClient, this, false, __ -> this.f_58857_.m_5518_().m_7174_(this.m_58899_()));
    private UUID ringId = UUID.randomUUID();
    private Vec3 ringCentroidPos;
    private final TimerBag<UUID> cartTimers = new TimerBag(8);
    private final TrackLocator trackLocator;

    public TokenSignalBlockEntity(BlockPos blockPos, BlockState blockState) {
        this((BlockEntityType)RailcraftBlockEntityTypes.TOKEN_SIGNAL.get(), blockPos, blockState);
    }

    public TokenSignalBlockEntity(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState) {
        super(type, blockPos, blockState);
        this.trackLocator = new TrackLocator(() -> ((TokenSignalBlockEntity)this).m_58904_(), blockPos);
    }

    public void onLoad() {
        super.onLoad();
        if (!this.f_58857_.m_5776_()) {
            this.signalController.refresh();
        }
    }

    public void blockRemoved() {
        this.signalController.destroy();
        if (!this.f_58857_.m_5776_()) {
            this.signalNetwork().removePeer(this.m_58899_());
        }
    }

    public static void clientTick(Level level, BlockPos blockPos, BlockState blockState, TokenSignalBlockEntity blockEntity) {
        blockEntity.signalController.spawnTuningAuraParticles();
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, TokenSignalBlockEntity blockEntity) {
        BlockPos trackPos;
        SimpleTokenRing tokenRing = blockEntity.signalNetwork();
        if (!Objects.equals(blockEntity.ringCentroidPos, tokenRing.getCentroid())) {
            blockEntity.ringCentroidPos = tokenRing.getCentroid();
            blockEntity.syncToClient();
        }
        blockEntity.cartTimers.tick();
        if (blockEntity.trackLocator.trackStatus() == TrackLocator.Status.VALID && (trackPos = blockEntity.trackLocator.trackPos()) != null) {
            EntitySearcher.findMinecarts().at(trackPos).stream(level).filter(cart -> blockEntity.cartTimers.add(cart.m_20148_())).forEach(tokenRing::markCart);
        }
        blockEntity.signalController.setSignalAspect(blockEntity.signalNetwork().aspect());
    }

    @Override
    public SignalAspect getPrimarySignalAspect() {
        return this.signalController.aspect();
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("network", (Tag)this.signalController.serializeNBT());
        tag.m_128362_("tokenRingId", this.ringId);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.signalController.deserializeNBT(tag.m_128469_("network"));
        this.ringId = tag.m_128342_("tokenRingId");
    }

    @Override
    public void writeToBuf(FriendlyByteBuf data) {
        super.writeToBuf(data);
        this.signalController.writeToBuf(data);
        data.m_236821_((Object)this.ringCentroidPos, (buf, vec3) -> {
            buf.writeDouble(vec3.m_7096_());
            buf.writeDouble(vec3.m_7098_());
            buf.writeDouble(vec3.m_7094_());
        });
        data.m_130077_(this.ringId);
    }

    @Override
    public void readFromBuf(FriendlyByteBuf data) {
        super.readFromBuf(data);
        this.signalController.readFromBuf(data);
        this.ringCentroidPos = (Vec3)data.m_236868_(buf -> new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble()));
        this.ringId = data.m_130259_();
    }

    @Override
    public UUID ringId() {
        return this.ringId;
    }

    @Override
    public void setRingId(UUID tokenRingId) {
        this.ringId = tokenRingId;
        this.m_6596_();
    }

    @Override
    public Vec3 ringCentroidPos() {
        if (this.ringCentroidPos == null) {
            return this.m_58899_().m_252807_();
        }
        return this.ringCentroidPos;
    }

    @Override
    public SimpleSignalController getSignalController() {
        return this.signalController;
    }

    @Override
    public SimpleTokenRing signalNetwork() {
        if (this.f_58857_.m_5776_()) {
            throw new IllegalStateException("Token ring is not available on the client.");
        }
        return TokenRingManager.get((ServerLevel)this.f_58857_).getTokenRingNetwork(this.ringId, this.m_58899_());
    }

    @Override
    public TrackLocator trackLocator() {
        return this.trackLocator;
    }
}

