/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.multiblock;

import com.google.common.primitives.Ints;
import mods.railcraft.world.level.block.entity.multiblock.MultiblockBlockEntity;
import mods.railcraft.world.level.block.entity.multiblock.MultiblockPattern;
import mods.railcraft.world.level.gameevent.RailcraftGameEvents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.phys.Vec3;

public class MultiblockListener
implements GameEventListener {
    private final MultiblockBlockEntity<?, ?> blockEntity;
    private final PositionSource positionSource;
    private final int radius;

    public MultiblockListener(MultiblockBlockEntity<?, ?> blockEntity) {
        this.blockEntity = blockEntity;
        this.positionSource = new BlockPositionSource(blockEntity.m_58899_());
        int radius = 0;
        for (MultiblockPattern<?> pattern : blockEntity.getPatterns()) {
            radius = Math.max(radius, Ints.max((int[])new int[]{pattern.getXSize(), pattern.getYSize(), pattern.getZSize()}));
        }
        this.radius = radius;
    }

    public PositionSource m_142460_() {
        return this.positionSource;
    }

    public int m_142078_() {
        return this.radius;
    }

    public boolean m_214068_(ServerLevel serverLevel, GameEvent gameEvent, GameEvent.Context context, Vec3 source) {
        if (gameEvent.equals(RailcraftGameEvents.NEIGHBOR_NOTIFY.get())) {
            this.blockEntity.enqueueEvaluation();
        }
        return false;
    }
}

