/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.multiblock;

import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import mods.railcraft.util.LevelUtil;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntity;
import mods.railcraft.world.level.block.entity.multiblock.MultiblockPattern;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkHooks;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public abstract class MultiblockBlockEntity<T extends MultiblockBlockEntity<T, M>, M>
extends RailcraftBlockEntity
implements MenuProvider {
    private static final Logger logger = LogUtils.getLogger();
    private final Class<T> clazz;
    private final Collection<MultiblockPattern<M>> patterns;
    @Nullable
    private Membership<T> membership;
    @Nullable
    private Map<BlockPos, T> members;
    @Nullable
    private MultiblockPattern<M> currentPattern;
    private boolean evaluationPending;
    @Nullable
    private UnresolvedMembership unresolvedMembership;

    public MultiblockBlockEntity(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState, Class<T> clazz, MultiblockPattern<M> pattern) {
        this(type, blockPos, blockState, clazz, Collections.singleton(pattern));
    }

    public MultiblockBlockEntity(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState, Class<T> clazz, Collection<MultiblockPattern<M>> patterns) {
        super(type, blockPos, blockState);
        this.clazz = clazz;
        this.patterns = Collections.unmodifiableCollection(patterns);
    }

    public Collection<MultiblockPattern<M>> getPatterns() {
        return this.patterns;
    }

    public void enqueueEvaluation() {
        this.evaluationPending = true;
    }

    protected void serverTick() {
        if (this.evaluationPending) {
            this.evaluate();
        }
    }

    public InteractionResult use(ServerPlayer player, InteractionHand hand) {
        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)this, (BlockPos)this.m_58899_());
        return InteractionResult.CONSUME;
    }

    public void evaluate() {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        this.evaluationPending = false;
        if (this.isFormed() && !this.isMaster()) {
            ((MultiblockBlockEntity)this.membership.master).evaluate();
            return;
        }
        Optional<Pair<MultiblockPattern<M>, Map<BlockPos, MultiblockPattern.Element>>> pattern = this.resolvePattern();
        if (this.isFormed() && (!this.isMaster() || pattern.isPresent()) || !this.isFormed() && pattern.isEmpty()) {
            return;
        }
        pattern.ifPresentOrElse(pair -> {
            this.currentPattern = (MultiblockPattern)pair.getLeft();
            this.members = new HashMap<BlockPos, T>();
            Map resolvedPattern = (Map)pair.getRight();
            for (Map.Entry entry : resolvedPattern.entrySet()) {
                if (!this.isBlockEntity((MultiblockPattern.Element)entry.getValue())) continue;
                MultiblockBlockEntity blockEntity = LevelUtil.getBlockEntity((BlockGetter)this.f_58857_, (BlockPos)entry.getKey(), this.clazz).orElse(null);
                if (blockEntity == null) {
                    logger.warn("Invalid block @ [{}]", entry.getKey());
                    this.disband();
                    return;
                }
                if (blockEntity.getMembership().isPresent()) {
                    this.disband();
                    return;
                }
                blockEntity.setMembership(new Membership<MultiblockBlockEntity>((MultiblockPattern.Element)entry.getValue(), (MultiblockBlockEntity)this.clazz.cast(this)));
                this.members.put((BlockPos)entry.getKey(), blockEntity);
            }
        }, this::disband);
    }

    private void disband() {
        this.currentPattern = null;
        if (this.members == null) {
            return;
        }
        for (Map.Entry<BlockPos, T> entry : this.members.entrySet()) {
            if (((MultiblockBlockEntity)entry.getValue()).m_58901_()) continue;
            ((MultiblockBlockEntity)entry.getValue()).setMembership(null);
        }
        this.members = null;
    }

    protected abstract boolean isBlockEntity(MultiblockPattern.Element var1);

    public Optional<Pair<MultiblockPattern<M>, Map<BlockPos, MultiblockPattern.Element>>> resolvePattern() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return this.patterns.stream().flatMap(pattern -> pattern.resolve(this.m_58899_(), serverLevel).map(map -> Pair.of((Object)pattern, (Object)map)).stream()).findAny();
        }
        throw new IllegalStateException("Resolving multiblock pattern on invalid side.");
    }

    protected void setMembership(@Nullable Membership<T> membership) {
        this.membership = membership;
        this.membershipChanged(membership);
        this.m_6596_();
        this.syncToClient();
    }

    protected abstract void membershipChanged(@Nullable Membership<T> var1);

    public boolean isFormed() {
        return this.membership != null;
    }

    public boolean isMaster() {
        return this.f_58857_.m_5776_() ? this.unresolvedMembership != null && this.unresolvedMembership.masterPos().equals((Object)this.f_58858_) : this.membership != null && this.membership.master() == this;
    }

    public Optional<Membership<T>> getMembership() {
        return this.f_58857_.m_5776_() ? Optional.empty() : Optional.ofNullable(this.membership);
    }

    public Optional<T> getMasterBlockEntity() {
        return this.getMembership().map(Membership::master);
    }

    public Optional<MultiblockPattern<M>> getCurrentPattern() {
        return Optional.ofNullable(this.currentPattern);
    }

    public Optional<UnresolvedMembership> getUnresolvedMembership() {
        if (!this.f_58857_.m_5776_()) {
            throw new IllegalStateException("getUnresolvedMembership is client-side only.");
        }
        return Optional.ofNullable(this.unresolvedMembership);
    }

    public Optional<Collection<T>> getMembers() {
        return Optional.ofNullable(this.members).map(Map::values);
    }

    public Stream<T> streamMembers() {
        return Stream.ofNullable(this.members).map(Map::values).flatMap(Collection::stream);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128471_("master")) {
            this.enqueueEvaluation();
        }
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("master", this.membership != null && this.membership.master() == this);
    }

    @Override
    public void writeToBuf(FriendlyByteBuf out) {
        super.writeToBuf(out);
        out.m_236821_(this.membership, (buf, membership) -> {
            MultiblockPattern.Element patternElement = membership.patternElement();
            buf.m_130064_(patternElement.relativePos());
            buf.writeChar((int)patternElement.marker());
            buf.m_130064_(membership.master().m_58899_());
        });
    }

    @Override
    public void readFromBuf(FriendlyByteBuf in) {
        super.readFromBuf(in);
        this.unresolvedMembership = (UnresolvedMembership)in.m_236868_(buf -> new UnresolvedMembership(new MultiblockPattern.Element(in.m_130135_(), in.readChar()), in.m_130135_()));
    }

    public record Membership<T extends MultiblockBlockEntity<T, ?>>(MultiblockPattern.Element patternElement, T master) {
    }

    public record UnresolvedMembership(MultiblockPattern.Element patternElement, BlockPos masterPos) {
    }
}

