/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import mods.railcraft.particle.FireSparkParticleOptions;
import mods.railcraft.util.fluids.FluidTools;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntity;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class RitualBlockEntity
extends RailcraftBlockEntity {
    public static final int[] REBUILD_DELAY = (int[])Util.m_137469_((Object)new int[8], delay -> {
        delay[0] = 128;
        delay[1] = 256;
        delay[2] = 512;
        delay[3] = 1024;
        delay[4] = 2048;
        delay[5] = 4096;
        delay[6] = 8192;
        delay[7] = 16384;
    });
    private final Deque<BlockPos> queue = new ArrayDeque<BlockPos>();
    private final Deque<BlockPos> lavaFound = new ArrayDeque<BlockPos>();
    private final Set<BlockPos> visitedBlocks = new HashSet<BlockPos>();
    private int charge;
    private int rebuildDelay;
    private Component itemName;
    private int tick = 0;
    private long rotationYaw;
    private long preRotationYaw;
    private float yOffset = -2.0f;
    private float preYOffset = -2.0f;

    public RitualBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RailcraftBlockEntityTypes.RITUAL.get(), blockPos, blockState);
    }

    public static void clientTick(Level level, BlockPos blockPos, BlockState blockState, RitualBlockEntity blockEntity) {
        blockEntity.preRotationYaw = blockEntity.rotationYaw;
        blockEntity.rotationYaw += 5L;
        if (blockEntity.rotationYaw >= 360L) {
            blockEntity.preRotationYaw = blockEntity.rotationYaw = 0L;
        }
        blockEntity.preYOffset = blockEntity.yOffset;
        if (blockEntity.yOffset < 0.0f) {
            blockEntity.yOffset += 0.0625f;
        }
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, RitualBlockEntity blockEntity) {
        BlockPos pos;
        if (blockEntity.charge >= 5000) {
            blockEntity.tick = 0;
            return;
        }
        if (blockEntity.tick % REBUILD_DELAY[blockEntity.rebuildDelay] == 0) {
            ++blockEntity.rebuildDelay;
            if (blockEntity.rebuildDelay >= REBUILD_DELAY.length) {
                blockEntity.rebuildDelay = REBUILD_DELAY.length - 1;
            }
            blockEntity.rebuildQueue();
        }
        if ((pos = blockEntity.getNextLavaBlock(true)) != null && blockEntity.coolLava((ServerLevel)level, pos)) {
            ++blockEntity.charge;
            blockEntity.rebuildDelay = 0;
        }
        ++blockEntity.tick;
    }

    private boolean coolLava(ServerLevel level, BlockPos lavaPos) {
        boolean placed;
        FluidState fluid = level.m_8055_(lavaPos).m_60819_();
        if (fluid.m_192917_((Fluid)Fluids.f_76195_) && (placed = level.m_46597_(lavaPos, Blocks.f_50080_.m_49966_()))) {
            Vec3 startPosition = Vec3.m_272021_((Vec3i)lavaPos, (double)0.5, (double)0.5, (double)0.5);
            Vec3 endPosition = Vec3.m_272021_((Vec3i)this.m_58899_(), (double)0.5, (double)0.8, (double)0.5);
            this.fireSparkEffect(level, startPosition, endPosition);
            this.queueAdjacent(lavaPos);
            this.expandQueue();
            return true;
        }
        return false;
    }

    private void fireSparkEffect(ServerLevel level, Vec3 start, Vec3 end) {
        level.m_8767_((ParticleOptions)new FireSparkParticleOptions(end), start.f_82479_, start.f_82480_, start.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
    }

    @Nullable
    private BlockPos getNextLavaBlock(boolean remove) {
        if (this.queue.isEmpty()) {
            return null;
        }
        if (remove) {
            return this.queue.pollFirst();
        }
        return this.queue.peekFirst();
    }

    void rebuildQueue() {
        this.queue.clear();
        this.visitedBlocks.clear();
        this.lavaFound.clear();
        this.queueAdjacent(this.m_58899_());
        this.expandQueue();
    }

    private void expandQueue() {
        BlockPos next;
        while ((next = this.lavaFound.poll()) != null) {
            this.queueAdjacent(next);
        }
    }

    public void queueAdjacent(BlockPos pos) {
        Direction.Plane.HORIZONTAL.forEach(side -> this.queueForFilling(pos.m_121945_(side)));
        this.queueForFilling(pos.m_7494_());
        this.queueForFilling(pos.m_7495_());
    }

    public void queueForFilling(BlockPos index) {
        if (this.visitedBlocks.add(index)) {
            if ((index.m_123341_() - this.f_58858_.m_123341_()) * (index.m_123341_() - this.f_58858_.m_123341_()) + (index.m_123343_() - this.f_58858_.m_123343_()) * (index.m_123343_() - this.f_58858_.m_123343_()) > 4096) {
                return;
            }
            BlockState state = this.f_58857_.m_8055_(index);
            if (state.m_60713_(Blocks.f_50080_) || FluidTools.getFluid(state).m_6212_((Fluid)Fluids.f_76195_)) {
                this.lavaFound.add(index);
                if (FluidTools.isFullFluidBlock(state, this.f_58857_, index)) {
                    this.queue.addLast(index);
                }
            }
        }
    }

    public void setItemName(Component itemName) {
        this.itemName = itemName;
    }

    public int charge() {
        return this.charge;
    }

    public void setCharge(int charge) {
        this.charge = charge;
    }

    public float getRotationYaw(float partialTick) {
        return Mth.m_14179_((float)partialTick, (float)this.preRotationYaw, (float)this.rotationYaw);
    }

    public float getYOffset(float partialTick) {
        return Mth.m_14179_((float)partialTick, (float)this.preYOffset, (float)this.yOffset);
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128376_("charge", (short)this.charge);
        tag.m_128344_("rebuildDelay", (byte)this.rebuildDelay);
        if (this.itemName != null) {
            tag.m_128359_("itemName", Component.Serializer.m_130703_((Component)this.itemName));
        }
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.charge = tag.m_128448_("charge");
        this.rebuildDelay = tag.m_128445_("rebuildDelay");
        if (tag.m_128425_("itemName", 8)) {
            this.itemName = Component.Serializer.m_130701_((String)tag.m_128461_("itemName"));
        }
    }
}

