/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import mods.railcraft.network.NetworkChannel;
import mods.railcraft.network.play.OpenLogBookScreen;
import mods.railcraft.util.EntitySearcher;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntity;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.StringUtils;

public class LogBookBlockEntity
extends RailcraftBlockEntity {
    private static final float SEARCH_RADIUS = 16.0f;
    private static final int BOOK_LINES_PER_PAGE = 13;
    private final Multimap<LocalDate, GameProfile> log = HashMultimap.create();
    private int clock = 0;

    public LogBookBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RailcraftBlockEntityTypes.LOGBOOK.get(), blockPos, blockState);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, LogBookBlockEntity blockEntity) {
        LocalDate date;
        boolean isChanged;
        List<Player> players;
        if (++blockEntity.clock % 32 == 0 && !(players = EntitySearcher.find(Player.class).at(blockPos).inflateHorizontally(16.0).list(level)).isEmpty() && (isChanged = blockEntity.log.putAll((Object)(date = LocalDate.now()), players.stream().map(Player::m_36316_).toList()))) {
            blockEntity.m_6596_();
        }
    }

    public static CompoundTag convertLogToTag(Multimap<LocalDate, GameProfile> log) {
        CompoundTag tag = new CompoundTag();
        LocalDate monthAgo = LocalDate.now().minusMonths(1L);
        ListTag logList = new ListTag();
        for (Map.Entry entry : log.asMap().entrySet()) {
            if (((LocalDate)entry.getKey()).isBefore(monthAgo)) continue;
            CompoundTag dateEntry = new CompoundTag();
            ListTag players = new ListTag();
            for (GameProfile player : (Collection)entry.getValue()) {
                CompoundTag playerTag = NbtUtils.m_129230_((CompoundTag)new CompoundTag(), (GameProfile)player);
                players.add((Object)playerTag);
            }
            dateEntry.m_128359_("date", ((LocalDate)entry.getKey()).toString());
            dateEntry.m_128365_("players", (Tag)players);
            logList.add((Object)dateEntry);
        }
        tag.m_128365_("entries", (Tag)logList);
        return tag;
    }

    public static Multimap<LocalDate, GameProfile> convertLogFromTag(CompoundTag tag) {
        HashMultimap log = HashMultimap.create();
        LocalDate monthAgo = LocalDate.now().minusMonths(1L);
        ListTag logList = tag.m_128437_("entries", 10);
        for (int i = 0; i < logList.size(); ++i) {
            CompoundTag compound = logList.m_128728_(i);
            LocalDate date = LocalDate.parse(compound.m_128461_("date"));
            try {
                if (date.isBefore(monthAgo)) continue;
                ListTag playerList = compound.m_128437_("players", 10);
                HashSet<GameProfile> players = new HashSet<GameProfile>();
                for (int j = 0; j < playerList.size(); ++j) {
                    CompoundTag playerCompound = playerList.m_128728_(i);
                    players.add(NbtUtils.m_129228_((CompoundTag)playerCompound));
                }
                log.putAll((Object)date, players);
                continue;
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
        }
        return log;
    }

    public void use(ServerPlayer player) {
        NetworkChannel.GAME.sendTo(new OpenLogBookScreen(LogBookBlockEntity.getPages(this.log)), player);
    }

    private static List<List<String>> getPages(Multimap<LocalDate, GameProfile> log) {
        ArrayList<List<String>> pages = new ArrayList<List<String>>();
        ArrayList days = new ArrayList(log.keySet());
        days.sort(Comparator.reverseOrder());
        for (LocalDate day : days) {
            List<String> page = LogBookBlockEntity.makePage(pages, day);
            for (GameProfile profile : log.get((Object)day)) {
                if (page.size() > 13) {
                    page = LogBookBlockEntity.makePage(pages, day);
                }
                page.add(profile.getName());
            }
        }
        return pages;
    }

    private static List<String> makePage(List<List<String>> pages, LocalDate date) {
        LinkedList<String> page = new LinkedList<String>();
        page.add(date.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT)));
        page.add(StringUtils.repeat((char)'-', (int)34));
        pages.add(page);
        return page;
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("log", (Tag)LogBookBlockEntity.convertLogToTag(this.log));
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.log.clear();
        this.log.putAll(LogBookBlockEntity.convertLogFromTag(tag.m_128469_("log")));
    }
}

