/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity;

import java.util.List;
import mods.railcraft.util.BoxBuilder;
import mods.railcraft.util.container.StackFilter;
import mods.railcraft.world.inventory.FeedStationMenu;
import mods.railcraft.world.level.block.FeedStationBlock;
import mods.railcraft.world.level.block.entity.ContainerBlockEntity;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class FeedStationBlockEntity
extends ContainerBlockEntity
implements MenuProvider {
    private static final int AREA = 3;
    private static final int MIN_FEED_INTERVAL = 128;
    private static final int FEED_VARIANCE = 256;
    private static final byte ANIMALS_PER_FOOD = 2;
    private int feedTime;
    private byte feedCounter;
    private int processingTicks;

    public FeedStationBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RailcraftBlockEntityTypes.FEED_STATION.get(), blockPos, blockState, 1);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, FeedStationBlockEntity blockEntity) {
        ItemStack feed = blockEntity.m_8020_(0);
        if (blockEntity.processingTicks++ >= 32 && (feed.m_41619_() || feed.m_41613_() < feed.m_41741_())) {
            blockEntity.findAdjacentContainers().moveOneItemTo(blockEntity, StackFilter.FEED);
            blockEntity.save();
        }
        feed = blockEntity.m_8020_(0);
        --blockEntity.feedTime;
        Boolean powered = (Boolean)blockState.m_61143_((Property)FeedStationBlock.POWERED);
        if (!powered.booleanValue() && !feed.m_41619_() && blockEntity.feedTime <= 0) {
            blockEntity.feedTime = 128 + level.m_213780_().m_188503_(256);
            AABB box = BoxBuilder.create().at(blockPos).raiseFloor(-1.0).raiseCeiling(2.0).inflateHorizontally(3.0).build();
            List animals = level.m_45976_(Animal.class, box);
            for (Animal target : animals) {
                if (!target.m_6898_(blockEntity.m_8020_(0)) || !blockEntity.feedAnimal(target)) continue;
                if (blockEntity.feedCounter <= 0) {
                    feed.m_41774_(1);
                    blockEntity.feedCounter = (byte)2;
                }
                blockEntity.feedCounter = (byte)(blockEntity.feedCounter - 1);
                blockEntity.save();
                break;
            }
        }
    }

    private boolean feedAnimal(Animal animal) {
        if (animal.m_146764_() == 0 && animal.m_5957_()) {
            Player player;
            Level level = this.f_58857_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                player = this.getOwner().map(profile -> serverLevel.m_7654_().m_6846_().m_11259_(profile.getId())).orElse(null);
            } else {
                player = null;
            }
            Player player2 = player;
            animal.m_27595_(player2);
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123748_, animal.m_20208_(1.0), animal.m_20187_() + 0.5, animal.m_20262_(1.0), 0.0, 0.0, 0.0);
            return true;
        }
        return false;
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.feedCounter = tag.m_128445_("feedCounter");
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128344_("feedCounter", this.feedCounter);
    }

    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new FeedStationMenu(id, inventory, this);
    }
}

