/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.item.crafting;

import java.util.function.Predicate;
import java.util.stream.IntStream;
import mods.railcraft.world.item.RailcraftItems;
import mods.railcraft.world.item.crafting.RailcraftRecipeSerializers;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class RotorRepairRecipe
extends CustomRecipe {
    public static final int REPAIR_PER_BLADE = 2500;
    private static final Ingredient ROTOR = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)RailcraftItems.TURBINE_ROTOR.get()});
    private static final Ingredient BLADE = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)RailcraftItems.TURBINE_BLADE.get()});

    public RotorRepairRecipe(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    public boolean matches(CraftingContainer container, Level level) {
        return container.m_216874_((Predicate)ROTOR) && container.m_216874_((Predicate)BLADE);
    }

    public ItemStack assemble(CraftingContainer container, RegistryAccess registryAccess) {
        ItemStack rotor = IntStream.range(0, container.m_6643_()).mapToObj(arg_0 -> ((CraftingContainer)container).m_8020_(arg_0)).filter((Predicate<ItemStack>)ROTOR).findFirst().orElse(ItemStack.f_41583_);
        if (rotor.m_41619_()) {
            return ItemStack.f_41583_;
        }
        long numBlades = IntStream.range(0, container.m_6643_()).mapToObj(arg_0 -> ((CraftingContainer)container).m_8020_(arg_0)).filter((Predicate<ItemStack>)BLADE).count();
        int damage = rotor.m_41773_();
        if ((damage = (int)((long)damage - 2500L * numBlades)) < 0) {
            damage = 0;
        }
        ItemStack result = rotor.m_41777_();
        result.m_41721_(damage);
        return result;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList ingredients = NonNullList.m_122779_();
        ingredients.add((Object)ROTOR);
        ingredients.add((Object)BLADE);
        return ingredients;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return new ItemStack((ItemLike)RailcraftItems.TURBINE_ROTOR.get());
    }

    public boolean m_8004_(int width, int height) {
        return width >= 2 && height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RailcraftRecipeSerializers.ROTOR_REPAIR.get();
    }
}

