/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.item;

import com.google.common.base.Suppliers;
import java.util.function.Supplier;
import mods.railcraft.tags.RailcraftTags;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public enum RailcraftArmorMaterial implements ArmorMaterial
{
    OVERALLS("railcraft:overalls", 5, new int[]{1, 2, 3, 1}, 15, SoundEvents.f_11678_, 0.0f, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50105_})),
    GOGGLES("railcraft:goggles", 20, new int[]{1, 2, 3, 1}, 15, SoundEvents.f_11678_, 0.0f, 0.0f, () -> Ingredient.m_204132_(RailcraftTags.Items.STEEL_INGOT)),
    STEEL("railcraft:steel", 25, new int[]{2, 5, 6, 2}, 8, SoundEvents.f_11677_, 0.8f, 0.0f, () -> Ingredient.m_204132_(RailcraftTags.Items.STEEL_INGOT));

    private static final int[] HEALTH_PER_SLOT;
    private final String name;
    private final int durabilityMultiplier;
    private final int[] slotProtections;
    private final int enchantmentValue;
    private final SoundEvent sound;
    private final float toughness;
    private final float knockbackResistance;
    private final Supplier<Ingredient> repairIngredient;

    private RailcraftArmorMaterial(String name, int durabilityMultiplier, int[] slotProtections, int enchantmentValue, SoundEvent sound, float toughness, float knockbackResistance, Supplier<Ingredient> repairIngredient) {
        this.name = name;
        this.durabilityMultiplier = durabilityMultiplier;
        this.slotProtections = slotProtections;
        this.enchantmentValue = enchantmentValue;
        this.sound = sound;
        this.toughness = toughness;
        this.knockbackResistance = knockbackResistance;
        this.repairIngredient = Suppliers.memoize(repairIngredient::get);
    }

    public int m_266425_(ArmorItem.Type type) {
        return HEALTH_PER_SLOT[type.m_266308_().m_20749_()] * this.durabilityMultiplier;
    }

    public int m_7366_(ArmorItem.Type type) {
        return this.slotProtections[type.m_266308_().m_20749_()];
    }

    public int m_6646_() {
        return this.enchantmentValue;
    }

    public SoundEvent m_7344_() {
        return this.sound;
    }

    public Ingredient m_6230_() {
        return this.repairIngredient.get();
    }

    public String m_6082_() {
        return this.name;
    }

    public float m_6651_() {
        return this.toughness;
    }

    public float m_6649_() {
        return this.knockbackResistance;
    }

    static {
        HEALTH_PER_SLOT = new int[]{13, 15, 16, 11};
    }
}

