/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.item;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import mods.railcraft.api.item.ActivationBlockingItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@ActivationBlockingItem
public abstract class PairingToolItem<T, P>
extends Item {
    private static final Logger logger = LogUtils.getLogger();

    public PairingToolItem(Item.Properties properties) {
        super(properties);
    }

    protected abstract Class<T> targetType();

    protected abstract Class<P> peerType();

    public final InteractionResult onItemUseFirst(ItemStack itemStack, UseOnContext context) {
        Level level = context.m_43725_();
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Player player = context.m_43723_();
        BlockPos pos = context.m_8083_();
        GlobalPos targetPos = PairingToolItem.getTargetPos(itemStack).orElse(null);
        if (targetPos != null) {
            if (targetPos.m_122646_().equals((Object)pos)) {
                this.displayMessageForState(player, State.ABANDONED);
                return InteractionResult.CONSUME;
            }
            if (targetPos.m_122640_().compareTo(level.m_46472_()) != 0) {
                ServerLevel dimension = level.m_7654_().m_129880_(targetPos.m_122640_());
                if (dimension != null) {
                    this.abandon(PairingToolItem.getBlockEntity((BlockGetter)dimension, targetPos.m_122646_(), this.targetType()));
                }
                PairingToolItem.clearTargetPos(itemStack);
                targetPos = null;
            }
        }
        if (targetPos == null) {
            T target = PairingToolItem.getBlockEntity((BlockGetter)level, pos, this.targetType());
            if (target == null) {
                this.displayMessageForState(player, State.INVALID_TARGET);
                return InteractionResult.FAIL;
            }
            Result result = this.begin(target);
            player.m_5661_(result.message(), true);
            if (result.success()) {
                PairingToolItem.setTargetPos(itemStack, GlobalPos.m_122643_((ResourceKey)level.m_46472_(), (BlockPos)pos));
                return InteractionResult.CONSUME;
            }
            return InteractionResult.FAIL;
        }
        T targetEntity = PairingToolItem.getBlockEntity((BlockGetter)level, targetPos.m_122646_(), this.targetType());
        if (player.m_6144_()) {
            this.abandon(targetEntity);
            this.displayMessageForState(player, State.ABANDONED);
            PairingToolItem.clearTargetPos(itemStack);
            return InteractionResult.CONSUME;
        }
        if (targetEntity == null) {
            this.displayMessageForState(player, State.LOST_TARGET);
            PairingToolItem.clearTargetPos(itemStack);
            return InteractionResult.FAIL;
        }
        P peerEntity = PairingToolItem.getBlockEntity((BlockGetter)level, pos, this.peerType());
        if (peerEntity == null) {
            this.displayMessageForState(player, State.INVALID_PEER);
            return InteractionResult.FAIL;
        }
        if (targetEntity == peerEntity) {
            throw new IllegalStateException("Target entity is the same as the peer entity.");
        }
        Result result = this.complete(targetEntity, peerEntity);
        player.m_5661_(result.message(), true);
        PairingToolItem.clearTargetPos(itemStack);
        return result.success() ? InteractionResult.CONSUME : InteractionResult.FAIL;
    }

    private void displayMessageForState(Player player, State state) {
        player.m_5661_(this.getMessageForState(state), true);
    }

    protected abstract Component getMessageForState(State var1);

    protected abstract void abandon(@Nullable T var1);

    protected abstract Result begin(T var1);

    protected abstract Result complete(T var1, P var2);

    private static <T> T getBlockEntity(BlockGetter getter, BlockPos pos, Class<T> type) {
        BlockEntity entity = getter.m_7702_(pos);
        return type.isInstance(entity) ? (T)type.cast(entity) : null;
    }

    public static Optional<GlobalPos> getTargetPos(ItemStack itemStack) {
        CompoundTag tag = itemStack.m_41783_();
        return tag != null && tag.m_128425_("peerPos", 10) ? GlobalPos.f_122633_.parse((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128469_("peerPos")).resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)) : Optional.empty();
    }

    public static void setTargetPos(ItemStack itemStack, GlobalPos peerPos) {
        GlobalPos.f_122633_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)peerPos).resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(tag -> itemStack.m_41784_().m_128365_("peerPos", tag));
    }

    public static void clearTargetPos(ItemStack itemStack) {
        CompoundTag tag = itemStack.m_41783_();
        if (tag != null) {
            tag.m_128473_("peerPos");
        }
    }

    public static <T> boolean checkAbandonPairing(GlobalPos signalPos, Player player, ServerLevel level, Runnable stopLinking) {
        if (signalPos.m_122640_().compareTo(level.m_46472_()) != 0) {
            return true;
        }
        if (player.m_6144_()) {
            stopLinking.run();
            return true;
        }
        return false;
    }

    protected static enum State {
        ABANDONED,
        LOST_TARGET,
        INVALID_TARGET,
        INVALID_PEER;

    }

    protected record Result(boolean success, Component message) {
        public static Result success(Component message) {
            return new Result(true, message);
        }

        public static Result failure(Component message) {
            return new Result(false, message);
        }
    }
}

