/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.item;

import java.util.List;
import java.util.Set;
import mods.railcraft.Translations;
import mods.railcraft.api.item.Crowbar;
import mods.railcraft.tags.RailcraftTags;
import mods.railcraft.util.LevelUtil;
import mods.railcraft.world.item.enchantment.RailcraftEnchantments;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class CrowbarItem
extends DiggerItem
implements Crowbar {
    private static final int BOOST_DAMAGE = 1;
    private final Set<Class<? extends Block>> shiftRotations = Set.of(LeverBlock.class, ButtonBlock.class, ChestBlock.class);
    private final Set<Class<? extends Block>> bannedRotations = Set.of(BaseRailBlock.class);

    public CrowbarItem(float attackDamage, float attackSpeed, Tier tier, Item.Properties properties) {
        super(attackDamage, attackSpeed, tier, RailcraftTags.Blocks.MINEABLE_WITH_CROWBAR, properties);
    }

    public boolean doesSneakBypassUse(ItemStack stack, LevelReader world, BlockPos pos, Player player) {
        return true;
    }

    private boolean isShiftRotation(Class<? extends Block> cls) {
        return this.shiftRotations.stream().anyMatch(shift -> shift.isAssignableFrom(cls));
    }

    private boolean isBannedRotation(Class<? extends Block> cls) {
        return this.bannedRotations.stream().anyMatch(banned -> banned.isAssignableFrom(cls));
    }

    public InteractionResult onItemUseFirst(ItemStack itemStack, UseOnContext context) {
        BlockState newBlockState;
        BlockPos pos;
        Player player = context.m_43723_();
        InteractionHand hand = context.m_43724_();
        ItemStack stack = player.m_21120_(hand);
        Level level = context.m_43725_();
        BlockState blockState = level.m_8055_(pos = context.m_8083_());
        if (blockState.m_60795_()) {
            return InteractionResult.PASS;
        }
        if (player.m_6144_() != this.isShiftRotation(blockState.m_60734_().getClass())) {
            return InteractionResult.PASS;
        }
        if (this.isBannedRotation(blockState.m_60734_().getClass())) {
            return InteractionResult.PASS;
        }
        if (!level.m_5776_() && (newBlockState = blockState.rotate((LevelAccessor)level, pos, Rotation.CLOCKWISE_90)) != blockState) {
            level.m_46597_(pos, newBlockState);
            player.m_6674_(hand);
            stack.m_41622_(1, (LivingEntity)player, __ -> player.m_21190_(hand));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean m_6813_(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        int enchantLevel;
        Player player;
        if (!level.m_5776_() && entityLiving instanceof Player && !(player = (Player)entityLiving).m_6144_() && (enchantLevel = stack.getEnchantmentLevel((Enchantment)RailcraftEnchantments.DESTRUCTION.get()) * 2 + 1) > 1) {
            CrowbarItem.checkBlock(level, enchantLevel, pos, player);
        }
        return super.m_6813_(stack, level, state, pos, entityLiving);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.m_41622_(2, attacker, __ -> attacker.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    @Override
    public boolean canWhack(Player player, InteractionHand hand, ItemStack crowbar, BlockPos pos) {
        return true;
    }

    @Override
    public void onWhack(Player player, InteractionHand hand, ItemStack crowbar, BlockPos pos) {
        crowbar.m_41622_(1, (LivingEntity)player, __ -> player.m_21190_(hand));
        player.m_6674_(hand);
    }

    @Override
    public boolean canLink(Player player, InteractionHand hand, ItemStack crowbar, AbstractMinecart cart) {
        return player.m_6144_();
    }

    @Override
    public void onLink(Player player, InteractionHand hand, ItemStack crowbar, AbstractMinecart cart) {
        crowbar.m_41622_(1, (LivingEntity)player, __ -> player.m_21190_(hand));
        player.m_6674_(hand);
    }

    @Override
    public boolean canBoost(Player player, InteractionHand hand, ItemStack crowbar, AbstractMinecart cart) {
        return !player.m_6144_();
    }

    @Override
    public void onBoost(Player player, InteractionHand hand, ItemStack crowbar, AbstractMinecart cart) {
        crowbar.m_41622_(1, (LivingEntity)player, __ -> player.m_21190_(hand));
        player.m_6674_(hand);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> lines, TooltipFlag flag) {
        lines.add((Component)Component.m_237115_((String)Translations.Tips.CROWBAR_DESC).m_130940_(ChatFormatting.ITALIC));
    }

    private static void removeExtraBlocks(Level level, int enchantmentLevel, BlockPos pos, Player player) {
        if (enchantmentLevel > 0) {
            LevelUtil.playerRemoveBlock(level, pos, player);
            CrowbarItem.checkBlocks(level, enchantmentLevel, pos, player);
        }
    }

    private static void checkBlock(Level level, int enchantmentLevel, BlockPos pos, Player player) {
        BlockState state = level.m_8055_(pos);
        if (player.m_36298_(state)) {
            CrowbarItem.removeExtraBlocks(level, enchantmentLevel - 1, pos, player);
        }
    }

    private static void checkBlocks(Level level, int enchantmentLevel, BlockPos pos, Player player) {
        CrowbarItem.checkBlock(level, enchantmentLevel, pos.m_7918_(0, 0, -1), player);
        CrowbarItem.checkBlock(level, enchantmentLevel, pos.m_7918_(0, 1, -1), player);
        CrowbarItem.checkBlock(level, enchantmentLevel, pos.m_7918_(0, -1, -1), player);
        CrowbarItem.checkBlock(level, enchantmentLevel, pos.m_7918_(0, 0, 1), player);
        CrowbarItem.checkBlock(level, enchantmentLevel, pos.m_7918_(0, 1, 1), player);
        CrowbarItem.checkBlock(level, enchantmentLevel, pos.m_7918_(0, -1, 1), player);
        CrowbarItem.checkBlock(level, enchantmentLevel, pos.m_7918_(1, 0, 0), player);
        CrowbarItem.checkBlock(level, enchantmentLevel, pos.m_7918_(1, 1, 0), player);
        CrowbarItem.checkBlock(level, enchantmentLevel, pos.m_7918_(1, -1, 0), player);
        CrowbarItem.checkBlock(level, enchantmentLevel, pos.m_7918_(-1, 0, 0), player);
        CrowbarItem.checkBlock(level, enchantmentLevel, pos.m_7918_(-1, 1, 0), player);
        CrowbarItem.checkBlock(level, enchantmentLevel, pos.m_7918_(-1, -1, 0), player);
        CrowbarItem.checkBlock(level, enchantmentLevel, pos.m_7494_(), player);
        CrowbarItem.checkBlock(level, enchantmentLevel, pos.m_7495_(), player);
    }
}

