/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.inventory;

import java.util.Collection;
import java.util.List;
import mods.railcraft.gui.widget.FluidGaugeWidget;
import mods.railcraft.gui.widget.WaterCollectionGaugeWidget;
import mods.railcraft.world.inventory.RailcraftMenu;
import mods.railcraft.world.inventory.RailcraftMenuTypes;
import mods.railcraft.world.inventory.slot.OutputSlot;
import mods.railcraft.world.inventory.slot.RailcraftSlot;
import mods.railcraft.world.level.block.entity.WaterTankSidingBlockEntity;
import mods.railcraft.world.level.material.StandardTank;
import mods.railcraft.world.module.WaterCollectionModule;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;

public class WaterTankSidingMenu
extends RailcraftMenu {
    private final FluidGaugeWidget fluidGauge;

    public WaterTankSidingMenu(int id, Inventory inventory, WaterTankSidingBlockEntity tank) {
        super((MenuType)RailcraftMenuTypes.WATER_TANK_SIDING.get(), id, inventory.f_35978_, tank::isStillValid);
        this.fluidGauge = this.createGauge(tank, 35, 20, 176, 0, 48, 47);
        this.addWidget(this.fluidGauge);
        this.m_38897_(new RailcraftSlot(tank.getModule(), 0, 116, 18));
        this.m_38897_(new OutputSlot(tank.getModule(), 1, 140, 36));
        this.m_38897_(new OutputSlot(tank.getModule(), 2, 116, 54));
        this.addInventorySlots(inventory);
    }

    public FluidGaugeWidget getFluidGauge() {
        return this.fluidGauge;
    }

    private FluidGaugeWidget createGauge(WaterTankSidingBlockEntity blockEntity, int x, int y, int u, int v, int w, int h) {
        StandardTank tank = blockEntity.getModule().getTank();
        List<WaterCollectionModule> modules = blockEntity.getMembers().stream().flatMap(Collection::stream).flatMap(member -> member.getModule(WaterCollectionModule.class).stream()).toList();
        return new WaterCollectionGaugeWidget(modules, tank, x, y, u, v, w, h);
    }
}

