/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.entity;

import mods.railcraft.util.LevelUtil;
import mods.railcraft.world.entity.RailcraftEntityTypes;
import mods.railcraft.world.item.CrackedFirestoneItem;
import mods.railcraft.world.item.FirestoneItem;
import mods.railcraft.world.level.block.RailcraftBlocks;
import mods.railcraft.world.level.block.RitualBlock;
import mods.railcraft.world.level.block.entity.RitualBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class FirestoneItemEntity
extends ItemEntity {
    private int clock;
    private boolean refined;

    public FirestoneItemEntity(EntityType<? extends FirestoneItemEntity> type, Level level) {
        super(type, level);
        this.m_32064_();
        this.m_20334_(this.f_19796_.m_188500_() * 0.2 - 0.1, 0.2, this.f_19796_.m_188500_() * 0.2 - 0.1);
    }

    public FirestoneItemEntity(Level level, Vec3 position, ItemStack itemStack) {
        this((EntityType<? extends FirestoneItemEntity>)((EntityType)RailcraftEntityTypes.FIRESTONE.get()), level);
        this.m_6034_(position.f_82479_, position.f_82480_, position.f_82481_);
        this.m_32045_(itemStack);
        this.lifespan = itemStack.getEntityLifespan(level);
    }

    public void m_8119_() {
        FirestoneItem item;
        Item item2;
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            return;
        }
        if (++this.clock % 4 == 0 && (item2 = this.m_32055_().m_41720_()) instanceof FirestoneItem && (item = (FirestoneItem)item2).spawnsFire() && this.m_9236_().m_46469_().m_46207_(GameRules.f_46131_)) {
            FirestoneItem.trySpawnFire(this.m_9236_(), this.m_20183_(), this.m_32055_(), this.m_19749_());
        }
    }

    public void m_20093_() {
        if (!this.refined || !this.m_6084_() || this.m_9236_().m_5776_()) {
            return;
        }
        BlockState firestoneBlock = ((RitualBlock)((Object)RailcraftBlocks.RITUAL.get())).m_49966_();
        BlockPos surface = this.m_20183_();
        if (!this.m_9236_().m_6425_(surface).m_205070_(FluidTags.f_13132_) && !this.m_9236_().m_6425_(surface.m_7494_()).m_205070_(FluidTags.f_13132_)) {
            return;
        }
        for (int i = 0; i < 10; ++i) {
            BlockEntity blockEntity;
            surface = surface.m_7494_();
            if (!this.m_9236_().m_8055_(surface).m_60795_() || !this.m_9236_().m_6425_(surface.m_7495_()).m_205070_(FluidTags.f_13132_)) continue;
            boolean cracked = this.m_32055_().m_41720_() instanceof CrackedFirestoneItem;
            if (!LevelUtil.setBlockState(this.m_9236_(), surface, (BlockState)firestoneBlock.m_61124_((Property)RitualBlock.CRACKED, (Comparable)Boolean.valueOf(cracked)), this.m_19749_()) || !((blockEntity = this.m_9236_().m_7702_(surface)) instanceof RitualBlockEntity)) continue;
            RitualBlockEntity fireEntity = (RitualBlockEntity)blockEntity;
            ItemStack firestone = this.m_32055_();
            fireEntity.setCharge(firestone.m_41776_() - firestone.m_41773_());
            if (firestone.m_41788_()) {
                fireEntity.setItemName(firestone.m_41611_());
            }
            this.m_6074_();
            return;
        }
    }

    public boolean isRefined() {
        return this.refined;
    }

    public void setRefined(boolean refined) {
        this.refined = refined;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("refined", this.refined);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.refined = compound.m_128471_("refined");
    }
}

