/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.util.routing.expression.condition;

import java.util.Locale;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Stream;
import mods.railcraft.Translations;
import mods.railcraft.util.routing.RoutingLogicException;
import mods.railcraft.util.routing.RoutingStatementParser;
import mods.railcraft.util.routing.expression.Expression;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.registries.ForgeRegistries;

public class RiderCondition {
    public static final String KEYWORD = "Rider";

    public static Expression parse(String line) throws RoutingLogicException {
        RoutingStatementParser.ParsedStatement statement = RoutingStatementParser.parse(KEYWORD, true, line);
        String[] tokens = statement.value().split(":");
        Type type = Type.valueOf(tokens[0].toUpperCase(Locale.ROOT));
        if (statement.isRegex()) {
            RiderCondition.checkRegexSyntax(type, tokens, line);
        }
        RiderCondition.checkSyntax(type, tokens, line);
        Context context = new Context(statement, tokens);
        return (router, rollingStock) -> type.matches(rollingStock.train().passengers(), context);
    }

    private static void checkRegexSyntax(Type type, String[] tokens, String line) throws RoutingLogicException {
        switch (type) {
            case ANY: 
            case NONE: 
            case MOB: 
            case ANIMAL: 
            case UNNAMED: 
            case ENTITY: {
                throw new RoutingLogicException(Translations.RoutingTable.ERROR_UNSUPPORTED_REGEX, line);
            }
            case NAMED: 
            case PLAYER: {
                if (tokens.length != 1) break;
                throw new RoutingLogicException(Translations.RoutingTable.ERROR_UNSUPPORTED_REGEX, line);
            }
        }
    }

    private static void checkSyntax(Type type, String[] tokens, String line) throws RoutingLogicException {
        switch (type) {
            case ANY: 
            case NONE: 
            case MOB: 
            case ANIMAL: 
            case UNNAMED: {
                if (tokens.length <= 1) break;
                throw new RoutingLogicException(Translations.RoutingTable.ERROR_MALFORMED_SYNTAX, line);
            }
            case ENTITY: {
                if (tokens.length != 1) break;
                throw new RoutingLogicException(Translations.RoutingTable.ERROR_MALFORMED_SYNTAX, line);
            }
            case NAMED: 
            case PLAYER: {
                if (tokens.length <= 2) break;
                throw new RoutingLogicException(Translations.RoutingTable.ERROR_MALFORMED_SYNTAX, line);
            }
            default: {
                throw new RoutingLogicException(Translations.RoutingTable.UNRECOGNIZED_KEYWORD, line);
            }
        }
    }

    private static enum Type {
        ANY(passengers -> passengers.findAny().isPresent()),
        NONE(passengers -> passengers.findAny().isEmpty()),
        MOB(passengers -> passengers.anyMatch(Monster.class::isInstance)),
        ANIMAL(passengers -> passengers.anyMatch(Animal.class::isInstance)),
        UNNAMED(passengers -> passengers.anyMatch(p -> !p.m_8077_())),
        ENTITY((passengers, context) -> passengers.anyMatch(e -> {
            String registryName = ForgeRegistries.ENTITY_TYPES.getKey((Object)e.m_6095_()).toString();
            return context.tokens[1].equalsIgnoreCase(registryName);
        })),
        PLAYER((passengers, context) -> {
            if (context.tokens.length < 2) {
                return passengers.anyMatch(Player.class::isInstance);
            }
            BiPredicate<String, String> predicate = context.statement.isRegex() ? String::matches : String::equalsIgnoreCase;
            return passengers.anyMatch(e -> e instanceof Player && predicate.test(e.m_7755_().getString(), context.tokens[1]));
        }),
        NAMED((passengers, context) -> {
            if (context.tokens.length < 2) {
                return passengers.anyMatch(Entity::m_8077_);
            }
            BiPredicate<String, String> predicate = context.statement.isRegex() ? String::matches : String::equalsIgnoreCase;
            return passengers.anyMatch(e -> e.m_8077_() && predicate.test(e.m_7770_().getString(), context.tokens[1]));
        });

        private final BiPredicate<Stream<Entity>, Context> predicate;

        private Type(Predicate<Stream<Entity>> predicate) {
            this((Stream<Entity> passengers, Context __) -> predicate.test((Stream<Entity>)passengers));
        }

        private Type(BiPredicate<Stream<Entity>, Context> predicate) {
            this.predicate = predicate;
        }

        private boolean matches(Stream<Entity> passengers, Context context) {
            return this.predicate.test(passengers, context);
        }
    }

    private record Context(RoutingStatementParser.ParsedStatement statement, String[] tokens) {
    }
}

