/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.network.play;

import java.util.function.Supplier;
import mods.railcraft.world.entity.vehicle.locomotive.Locomotive;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public record SetLocomotiveAttributesMessage(int entityId, Locomotive.Mode mode, Locomotive.Speed speed, Locomotive.Lock lock, boolean reverse) {
    public void encode(FriendlyByteBuf out) {
        out.m_130130_(this.entityId);
        out.m_130068_((Enum)this.mode);
        out.m_130068_((Enum)this.speed);
        out.m_130068_((Enum)this.lock);
        out.writeBoolean(this.reverse);
    }

    public static SetLocomotiveAttributesMessage decode(FriendlyByteBuf in) {
        return new SetLocomotiveAttributesMessage(in.m_130242_(), (Locomotive.Mode)in.m_130066_(Locomotive.Mode.class), (Locomotive.Speed)in.m_130066_(Locomotive.Speed.class), (Locomotive.Lock)in.m_130066_(Locomotive.Lock.class), in.readBoolean());
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        Locomotive locomotive;
        ServerPlayer player = ctx.get().getSender();
        Entity entity = player.m_9236_().m_6815_(this.entityId);
        if (entity instanceof Locomotive && (locomotive = (Locomotive)entity).canControl((Player)player)) {
            locomotive.applyAction((Player)player, false, loco -> {
                loco.setMode(this.mode);
                loco.setSpeed(this.speed);
                loco.setReverse(this.reverse);
                if (!loco.isLocked() || loco.getOwnerOrThrow().equals((Object)player.m_36316_())) {
                    loco.setLock(this.lock);
                    loco.setOwner(this.lock == Locomotive.Lock.UNLOCKED ? null : player.m_36316_());
                }
            });
        }
        return true;
    }
}

