/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.data.recipes.builders;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.world.item.crafting.CrusherRecipe;
import mods.railcraft.world.item.crafting.RailcraftRecipeSerializers;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.NotCondition;
import net.minecraftforge.common.crafting.conditions.TagEmptyCondition;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class CrusherRecipeBuilder {
    public static final int DEFAULT_PROCESSING_TIME = 200;
    private static final int MAX_SLOTS = 9;
    private final Ingredient ingredient;
    private final List<CrusherRecipe.CrusherOutput> probabilityOutputs;
    private final int processTime;
    private final List<ICondition> conditions;

    private CrusherRecipeBuilder(Ingredient ingredient, int processTime) {
        this.ingredient = ingredient;
        this.probabilityOutputs = new ArrayList<CrusherRecipe.CrusherOutput>();
        this.processTime = processTime;
        this.conditions = new ArrayList<ICondition>();
    }

    public static CrusherRecipeBuilder crush(ItemLike ingredient) {
        return CrusherRecipeBuilder.crush(Ingredient.m_43929_((ItemLike[])new ItemLike[]{ingredient}));
    }

    public static CrusherRecipeBuilder crush(TagKey<Item> ingredient) {
        CrusherRecipeBuilder builder = CrusherRecipeBuilder.crush(Ingredient.m_204132_(ingredient));
        builder.conditions.add((ICondition)new NotCondition((ICondition)new TagEmptyCondition(ingredient.f_203868_())));
        return builder;
    }

    public static CrusherRecipeBuilder crush(Ingredient ingredient) {
        return CrusherRecipeBuilder.crush(ingredient, 200);
    }

    public static CrusherRecipeBuilder crush(Ingredient ingredient, int processTime) {
        return new CrusherRecipeBuilder(ingredient, processTime);
    }

    public CrusherRecipeBuilder addResult(ItemLike output, int quantity, double probability) {
        return this.addResult(Ingredient.m_43929_((ItemLike[])new ItemLike[]{output}), quantity, probability);
    }

    public CrusherRecipeBuilder addResult(TagKey<Item> output, int quantity, double probability) {
        this.conditions.add((ICondition)new NotCondition((ICondition)new TagEmptyCondition(output.f_203868_())));
        return this.addResult(Ingredient.m_204132_(output), quantity, probability);
    }

    public CrusherRecipeBuilder addResult(Ingredient output, int quantity, double probability) {
        if (this.probabilityOutputs.size() >= 9) {
            throw new IllegalStateException("Reached the maximum number of available slots as a result: 9");
        }
        if (probability < 0.0 || probability > 1.0) {
            throw new IllegalStateException("The probability must be between 0 and 1! You have inserted: " + probability);
        }
        this.probabilityOutputs.add(new CrusherRecipe.CrusherOutput(output, quantity, probability));
        return this;
    }

    public void save(Consumer<FinishedRecipe> finishedRecipe) {
        Object itemPath;
        Ingredient.Value value = this.ingredient.f_43902_[0];
        if (value instanceof Ingredient.TagValue) {
            Ingredient.TagValue tagValue = (Ingredient.TagValue)value;
            String location = tagValue.f_43959_.f_203868_().m_135815_().replace("/", "_");
            itemPath = "tags_" + location;
        } else {
            itemPath = Arrays.stream(this.ingredient.m_43908_()).filter(x -> !x.m_150930_(Items.f_42127_)).findFirst().map(x -> ForgeRegistries.ITEMS.getKey((Object)x.m_41720_()).m_135815_()).orElseThrow();
        }
        this.save(finishedRecipe, (String)itemPath);
    }

    private void save(Consumer<FinishedRecipe> finishedRecipe, String path) {
        ResourceLocation customResourceLocation = RailcraftConstants.rl("crusher/crushing_" + path);
        finishedRecipe.accept(new Result(customResourceLocation, this.ingredient, this.probabilityOutputs, this.processTime, this.conditions));
    }

    private static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final Ingredient ingredient;
        private final List<CrusherRecipe.CrusherOutput> probabilityOutputs;
        private final int processTime;
        private final List<ICondition> conditions;

        public Result(ResourceLocation resourceLocation, Ingredient ingredient, List<CrusherRecipe.CrusherOutput> probabilityOutputs, int processTime, List<ICondition> conditions) {
            this.id = resourceLocation;
            this.ingredient = ingredient;
            this.probabilityOutputs = probabilityOutputs;
            this.processTime = processTime;
            this.conditions = conditions;
        }

        public void m_7917_(JsonObject jsonOut) {
            if (!this.conditions.isEmpty()) {
                JsonArray conditionArray = new JsonArray();
                for (ICondition condition : this.conditions) {
                    conditionArray.add((JsonElement)CraftingHelper.serialize((ICondition)condition));
                }
                jsonOut.add("conditions", (JsonElement)conditionArray);
            }
            if (this.processTime != 200) {
                jsonOut.addProperty("processTime", (Number)this.processTime);
            }
            jsonOut.add("ingredient", this.ingredient.m_43942_());
            JsonArray result = new JsonArray();
            for (CrusherRecipe.CrusherOutput item : this.probabilityOutputs) {
                JsonObject pattern = new JsonObject();
                pattern.add("result", item.output().m_43942_());
                if (item.quantity() != 1) {
                    pattern.addProperty("count", (Number)item.quantity());
                }
                pattern.addProperty("probability", (Number)item.probability());
                result.add((JsonElement)pattern);
            }
            jsonOut.add("outputs", (JsonElement)result);
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)RailcraftRecipeSerializers.CRUSHER.get();
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

