/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.data.recipes.builders;

import com.google.gson.JsonObject;
import java.util.function.Consumer;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.data.recipes.builders.AbstractCookingRecipeBuilder;
import mods.railcraft.world.item.crafting.RailcraftRecipeSerializers;
import net.minecraft.advancements.Advancement;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;

public class CokeOvenRecipeBuilder
extends AbstractCookingRecipeBuilder {
    public static final int DEFAULT_COOKING_TIME = 400;
    private final int creosoteOutput;

    private CokeOvenRecipeBuilder(ItemLike result, int count, Ingredient ingredient, float experience, int cookingTime, int creosoteOutput) {
        super(result, count, ingredient, experience, cookingTime);
        this.creosoteOutput = creosoteOutput;
    }

    public static CokeOvenRecipeBuilder coking(ItemLike result, Ingredient ingredient, float experience, int creosoteOutput) {
        return CokeOvenRecipeBuilder.coking(result, ingredient, experience, 400, creosoteOutput);
    }

    public static CokeOvenRecipeBuilder coking(ItemLike result, Ingredient ingredient, float experience, int cookingTime, int creosoteOutput) {
        return CokeOvenRecipeBuilder.coking(result, 1, ingredient, experience, cookingTime, creosoteOutput);
    }

    public static CokeOvenRecipeBuilder coking(ItemLike result, int resultCount, Ingredient ingredient, float experience, int cookingTime, int creosoteOutput) {
        return new CokeOvenRecipeBuilder(result, resultCount, ingredient, experience, cookingTime, creosoteOutput);
    }

    public void m_126140_(Consumer<FinishedRecipe> finishedRecipe, ResourceLocation resourceLocation) {
        String path = resourceLocation.m_135815_();
        ResourceLocation customResourceLocation = RailcraftConstants.rl("coke_oven/" + path);
        ResourceLocation advancementId = customResourceLocation.m_246208_("recipes/");
        finishedRecipe.accept(new Result(customResourceLocation, this.result, this.count, this.ingredient, this.experience, this.cookingTime, this.creosoteOutput, this.advancement, advancementId));
    }

    private static class Result
    extends AbstractCookingRecipeBuilder.AbstractResult {
        private final int creosoteOutput;

        public Result(ResourceLocation id, Item result, int count, Ingredient ingredient, float experience, int cookingTime, int creosoteOutput, Advancement.Builder advancement, ResourceLocation advancementId) {
            super(id, result, count, ingredient, experience, cookingTime, advancement, advancementId);
            this.creosoteOutput = creosoteOutput;
        }

        @Override
        protected void addJsonProperty(JsonObject json) {
            json.addProperty("creosoteOutput", (Number)this.creosoteOutput);
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)RailcraftRecipeSerializers.COKING.get();
        }
    }
}

