/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.renderer.entity.cart;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import mods.railcraft.api.carts.Routable;
import mods.railcraft.season.Seasons;
import mods.railcraft.world.entity.vehicle.Directional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.StringUtils;

public abstract class CustomMinecartRenderer<T extends AbstractMinecart>
extends EntityRenderer<T> {
    public CustomMinecartRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(T cart, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        boolean ghostTrain;
        Routable routable;
        String dest;
        String customName;
        poseStack.m_85836_();
        long i = (long)cart.m_19879_() * 493286711L;
        i = i * i * 4392167121L + i * 98761L;
        float f = (((float)(i >> 16 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float f1 = (((float)(i >> 20 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float f2 = (((float)(i >> 24 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        poseStack.m_252880_(f, f1, f2);
        double d0 = Mth.m_14139_((double)partialTicks, (double)((AbstractMinecart)cart).f_19790_, (double)cart.m_20185_());
        double d1 = Mth.m_14139_((double)partialTicks, (double)((AbstractMinecart)cart).f_19791_, (double)cart.m_20186_());
        double d2 = Mth.m_14139_((double)partialTicks, (double)((AbstractMinecart)cart).f_19792_, (double)cart.m_20189_());
        Vec3 vector3d = cart.m_38179_(d0, d1, d2);
        float pitch = Mth.m_14179_((float)partialTicks, (float)((AbstractMinecart)cart).f_19860_, (float)cart.m_146909_());
        if (vector3d != null) {
            Vec3 vector3d1 = cart.m_38096_(d0, d1, d2, (double)0.3f);
            Vec3 vector3d2 = cart.m_38096_(d0, d1, d2, (double)-0.3f);
            if (vector3d1 == null) {
                vector3d1 = vector3d;
            }
            if (vector3d2 == null) {
                vector3d2 = vector3d;
            }
            poseStack.m_85837_(vector3d.f_82479_ - d0, (vector3d1.f_82480_ + vector3d2.f_82480_) / 2.0 - d1, vector3d.f_82481_ - d2);
            Vec3 vector3d3 = vector3d2.m_82520_(-vector3d1.f_82479_, -vector3d1.f_82480_, -vector3d1.f_82481_);
            if (vector3d3.m_82553_() != 0.0) {
                vector3d3 = vector3d3.m_82541_();
                yaw = (float)(Math.atan2(vector3d3.f_82481_, vector3d3.f_82479_) * 180.0 / Math.PI);
                pitch = (float)(Math.atan(vector3d3.f_82480_) * 73.0);
            }
        }
        if ((yaw %= 360.0f) < 0.0f) {
            yaw += 360.0f;
        }
        yaw += 360.0f;
        float serverYaw = cart.m_146908_();
        serverYaw += 180.0f;
        if ((serverYaw %= 360.0f) < 0.0f) {
            serverYaw += 360.0f;
        }
        if (Math.abs(yaw - (serverYaw += 360.0f)) > 90.0f) {
            yaw += 180.0f;
            pitch = -pitch;
        }
        if (cart instanceof Directional) {
            Directional directional = (Directional)cart;
            directional.setRenderYaw(yaw);
        }
        poseStack.m_252880_(0.0f, 0.375f, 0.0f);
        boolean renderName = false;
        if (cart.m_8077_() && !"Ghost Train".equals(customName = cart.m_7770_().getString()) && !"Polar Express".equals(customName)) {
            this.m_7649_((Entity)cart, cart.m_7770_(), poseStack, bufferSource, packedLight);
            renderName = true;
        }
        if (cart instanceof Routable && !StringUtils.isBlank((CharSequence)(dest = (routable = (Routable)cart).getDestination()))) {
            poseStack.m_85836_();
            if (renderName) {
                poseStack.m_252880_(0.0f, 0.3f, 0.0f);
            }
            MutableComponent destination = Component.m_237113_((String)dest).m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.ITALIC});
            this.m_7649_((Entity)cart, (Component)destination, poseStack, bufferSource, packedLight);
            poseStack.m_85849_();
        }
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - yaw));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(-pitch));
        float roll = (float)cart.m_38176_() - partialTicks;
        float damage = cart.m_38169_() - partialTicks;
        if (damage < 0.0f) {
            damage = 0.0f;
        }
        if (roll > 0.0f) {
            poseStack.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14031_((float)roll) * roll * damage / 10.0f * (float)cart.m_38177_()));
        }
        float colorIntensity = (ghostTrain = Seasons.isGhostTrain(cart)) ? 0.5f : 1.0f;
        this.renderBody(cart, partialTicks, poseStack, bufferSource, packedLight, colorIntensity, colorIntensity, colorIntensity, ghostTrain ? 0.8f : 1.0f);
        if (ghostTrain) {
            poseStack.m_85836_();
            float scale = 1.1f;
            poseStack.m_85841_(scale, scale, scale);
            this.renderBody(cart, partialTicks, poseStack, bufferSource, packedLight, 1.0f, 1.0f, 1.0f, 0.4f);
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
    }

    protected abstract void renderBody(T var1, float var2, PoseStack var3, MultiBufferSource var4, int var5, float var6, float var7, float var8, float var9);
}

