/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import mods.railcraft.Translations;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.client.gui.screen.IngameWindowScreen;
import mods.railcraft.client.gui.widget.button.ButtonTexture;
import mods.railcraft.client.gui.widget.button.RailcraftButton;
import mods.railcraft.client.gui.widget.button.TexturePosition;
import mods.railcraft.network.NetworkChannel;
import mods.railcraft.network.play.EditTicketAttributeMessage;
import mods.railcraft.world.item.TicketItem;
import net.minecraft.ChatFormatting;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;

public class GoldenTicketScreen
extends IngameWindowScreen {
    private static final ResourceLocation TICKET_LOCATION = RailcraftConstants.rl("textures/gui/item/golden_ticket.png");
    private static final int IMAGE_WIDTH = 256;
    private static final int IMAGE_HEIGHT = 136;
    private static final String PREFIX = "Dest=";
    private final ItemStack itemStack;
    private final InteractionHand hand;
    private String dest;
    private RailcraftButton helpButton;
    private EditBox editBoxDest;
    private boolean readingManual;

    public GoldenTicketScreen(ItemStack itemStack, InteractionHand hand) {
        super(GameNarrator.f_93310_, TICKET_LOCATION, 256, 136);
        this.itemStack = itemStack;
        this.hand = hand;
        this.dest = PREFIX + TicketItem.getDestination(this.itemStack);
        this.readingManual = false;
    }

    protected void m_7856_() {
        RailcraftButton doneButton = (RailcraftButton)this.m_142416_((GuiEventListener)((RailcraftButton.Builder)RailcraftButton.builder(CommonComponents.f_130655_, button -> {
            this.sendMessageToServer();
            this.f_96541_.m_91152_(null);
        }, (TexturePosition)ButtonTexture.LARGE_BUTTON).size(64, 20)).build());
        this.helpButton = (RailcraftButton)this.m_142416_((GuiEventListener)((RailcraftButton.Builder)RailcraftButton.builder(Translations.Screen.HELP, button -> {
            this.readingManual = !this.readingManual;
        }, (TexturePosition)ButtonTexture.LARGE_BUTTON).size(64, 20)).build());
        RailcraftButton cancelButton = (RailcraftButton)this.m_142416_((GuiEventListener)((RailcraftButton.Builder)RailcraftButton.builder(CommonComponents.f_130656_, button -> this.f_96541_.m_91152_(null), (TexturePosition)ButtonTexture.LARGE_BUTTON).size(64, 20)).build());
        LinearLayout layout = new LinearLayout(this.f_96543_ / 2 - 100, this.f_96544_ / 2 + 75, 200, 20, LinearLayout.Orientation.HORIZONTAL);
        layout.m_264406_((LayoutElement)doneButton);
        layout.m_264406_((LayoutElement)this.helpButton);
        layout.m_264406_((LayoutElement)cancelButton);
        layout.m_264036_();
        this.editBoxDest = new EditBox(this.f_96547_, this.f_96543_ / 2 - 117, this.f_96544_ / 2 + 23, 234, 20, (Component)Component.m_237119_());
        this.editBoxDest.m_94144_(this.dest);
        this.editBoxDest.m_94182_(false);
        this.m_142416_((GuiEventListener)this.editBoxDest);
    }

    @Override
    protected void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.readingManual) {
            this.editBoxDest.m_94194_(false);
            MutableComponent about = Component.m_237115_((String)Translations.Screen.GOLDEN_TICKET_ABOUT);
            MutableComponent help = Component.m_237115_((String)Translations.Screen.GOLDEN_TICKET_HELP).m_130940_(ChatFormatting.BLACK);
            guiGraphics.m_280614_(this.f_96547_, (Component)about, this.windowWidth / 2 - this.f_96547_.m_92852_((FormattedText)about) / 2, 15, -12566464, false);
            guiGraphics.m_280554_(this.f_96547_, (FormattedText)help, 15, 30, 230, -12566464);
            this.helpButton.m_93666_(CommonComponents.f_130660_);
        } else {
            MutableComponent title = Component.m_237115_((String)Translations.Screen.GOLDEN_TICKET_TITLE).m_130944_(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.BOLD});
            MutableComponent desc1 = Component.m_237115_((String)Translations.Screen.GOLDEN_TICKET_DESC_1);
            MutableComponent desc2 = Component.m_237115_((String)Translations.Screen.GOLDEN_TICKET_DESC_2);
            PoseStack poseStack = guiGraphics.m_280168_();
            poseStack.m_85836_();
            poseStack.m_85841_(2.0f, 2.0f, 2.0f);
            guiGraphics.m_280653_(this.f_96547_, (Component)title, 64, 8, -12566464);
            poseStack.m_85849_();
            guiGraphics.m_280614_(this.f_96547_, (Component)desc1, this.windowWidth / 2 - this.f_96547_.m_92852_((FormattedText)desc1) / 2, 45, -12566464, false);
            guiGraphics.m_280614_(this.f_96547_, (Component)desc2, this.windowWidth / 2 - this.f_96547_.m_92852_((FormattedText)desc2) / 2, 60, -12566464, false);
            this.editBoxDest.m_94194_(true);
            this.helpButton.m_93666_((Component)Component.m_237115_((String)Translations.Screen.HELP));
        }
    }

    private void sendMessageToServer() {
        this.dest = this.editBoxDest.m_94155_();
        boolean isValid = this.dest.startsWith(PREFIX);
        if (!isValid) {
            return;
        }
        this.dest = this.dest.trim();
        String destWithoutPrefix = this.dest.substring(PREFIX.length());
        boolean success = TicketItem.setTicketData(this.itemStack, destWithoutPrefix, this.f_96541_.f_91074_.m_36316_());
        if (success) {
            NetworkChannel.GAME.sendToServer(new EditTicketAttributeMessage(this.hand, destWithoutPrefix));
        }
    }
}

